/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ad.ADSentenceSampleStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ADSentenceSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<SentenceSample, ADSentenceSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "ad.sample";
    private ADSentenceSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<SentenceSample, ADSentenceSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ADSentenceSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(SentenceSample.class, (String)"ad");
        Assertions.assertInstanceOf(ADSentenceSampleStreamFactory.class, (Object)f);
        this.factory = (ADSentenceSampleStreamFactory)f;
        Assertions.assertEquals(ADSentenceSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/ad/ad.sample").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void testCreateWithValidParameter(String includeTitles) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-includeTitles", includeTitles, "-lang", "por", "-encoding", "UTF-8", "-data", this.sampleFileFullPath});){
            SentenceSample sample = (SentenceSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-includeTitles", "false", "-lang", "por", "-encoding", "UTF-8", "-data", this.sampleFileFullPath + "xyz"});){
                SentenceSample sample = (SentenceSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

