/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ad.ADSentenceStream;
import opennlp.tools.formats.ad.AbstractADSampleStreamTest;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ADParagraphStreamTest
extends AbstractADSampleStreamTest<SentenceSample> {
    private ADSentenceStream stream;

    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
        this.stream = new ADSentenceStream((ObjectStream)new PlainTextByLineStream(this.in, StandardCharsets.UTF_8));
        Assertions.assertNotNull((Object)this.stream);
    }

    @Test
    void testSimpleReading() throws IOException {
        int count = 0;
        ADSentenceStream.Sentence paragraph = this.stream.read();
        paragraph.root();
        while (paragraph != null) {
            ++count;
            paragraph = this.stream.read();
        }
        Assertions.assertEquals((int)8, (int)count);
    }

    @Test
    void testLeadingWithContraction() throws IOException {
        int count = 0;
        ADSentenceStream.Sentence paragraph = this.stream.read();
        while (paragraph != null) {
            ++count;
            paragraph = this.stream.read();
        }
        Assertions.assertEquals((int)8, (int)count);
    }
}

