/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ad.ADPOSSampleStream;
import opennlp.tools.formats.ad.AbstractADSampleStreamTest;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ADPOSSampleStreamTest
extends AbstractADSampleStreamTest<POSSample> {
    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
    }

    @Test
    void testSimple() throws IOException {
        try (ADPOSSampleStream stream = new ADPOSSampleStream((ObjectStream)new PlainTextByLineStream(this.in, StandardCharsets.UTF_8), false, false);){
            POSSample sample = stream.read();
            Assertions.assertEquals((int)23, (int)sample.getSentence().length);
            Assertions.assertEquals((Object)"Inicia", (Object)sample.getSentence()[0]);
            Assertions.assertEquals((Object)"v-fin", (Object)sample.getTags()[0]);
            Assertions.assertEquals((Object)"em", (Object)sample.getSentence()[1]);
            Assertions.assertEquals((Object)"prp", (Object)sample.getTags()[1]);
            Assertions.assertEquals((Object)"o", (Object)sample.getSentence()[2]);
            Assertions.assertEquals((Object)"art", (Object)sample.getTags()[2]);
            Assertions.assertEquals((Object)"Porto_Poesia", (Object)sample.getSentence()[9]);
            Assertions.assertEquals((Object)"prop", (Object)sample.getTags()[9]);
        }
    }

    @Test
    void testExpandME() throws IOException {
        try (ADPOSSampleStream stream = new ADPOSSampleStream((ObjectStream)new PlainTextByLineStream(this.in, StandardCharsets.UTF_8), true, false);){
            POSSample sample = stream.read();
            Assertions.assertEquals((int)27, (int)sample.getSentence().length);
            Assertions.assertEquals((Object)"Inicia", (Object)sample.getSentence()[0]);
            Assertions.assertEquals((Object)"v-fin", (Object)sample.getTags()[0]);
            Assertions.assertEquals((Object)"em", (Object)sample.getSentence()[1]);
            Assertions.assertEquals((Object)"prp", (Object)sample.getTags()[1]);
            Assertions.assertEquals((Object)"o", (Object)sample.getSentence()[2]);
            Assertions.assertEquals((Object)"art", (Object)sample.getTags()[2]);
            Assertions.assertEquals((Object)"Porto", (Object)sample.getSentence()[9]);
            Assertions.assertEquals((Object)"B-prop", (Object)sample.getTags()[9]);
            Assertions.assertEquals((Object)"Poesia", (Object)sample.getSentence()[10]);
            Assertions.assertEquals((Object)"I-prop", (Object)sample.getTags()[10]);
        }
    }

    @Test
    void testIncludeFeats() throws IOException {
        try (ADPOSSampleStream stream = new ADPOSSampleStream((ObjectStream)new PlainTextByLineStream(this.in, StandardCharsets.UTF_8), false, true);){
            POSSample sample = stream.read();
            Assertions.assertEquals((int)23, (int)sample.getSentence().length);
            Assertions.assertEquals((Object)"Inicia", (Object)sample.getSentence()[0]);
            Assertions.assertEquals((Object)"v-fin=PR=3S=IND=VFIN", (Object)sample.getTags()[0]);
            Assertions.assertEquals((Object)"em", (Object)sample.getSentence()[1]);
            Assertions.assertEquals((Object)"prp", (Object)sample.getTags()[1]);
            Assertions.assertEquals((Object)"o", (Object)sample.getSentence()[2]);
            Assertions.assertEquals((Object)"art=DET=M=S", (Object)sample.getTags()[2]);
            Assertions.assertEquals((Object)"Porto_Poesia", (Object)sample.getSentence()[9]);
            Assertions.assertEquals((Object)"prop=M=S", (Object)sample.getTags()[9]);
        }
    }
}

