/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ad.ADPOSSampleStreamFactory;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ADPOSSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<POSSample, ADPOSSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "ad.sample";
    private ADPOSSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<POSSample, ADPOSSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ADPOSSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(POSSample.class, (String)"ad");
        Assertions.assertInstanceOf(ADPOSSampleStreamFactory.class, (Object)f);
        this.factory = (ADPOSSampleStreamFactory)f;
        Assertions.assertEquals(ADPOSSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/ad/ad.sample").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void testCreateWithValidParameter(String expandME) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-expandME", expandME, "-lang", "por", "-encoding", "UTF-8", "-data", this.sampleFileFullPath});){
            POSSample sample = (POSSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-expandME", "false", "-lang", "por", "-encoding", "UTF-8", "-data", this.sampleFileFullPath + "xyz"});){
                POSSample sample = (POSSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

