/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ad.ADNameSampleStream;
import opennlp.tools.formats.ad.AbstractADSampleStreamTest;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ADNameSampleStreamTest
extends AbstractADSampleStreamTest<NameSample> {
    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
        try (ADNameSampleStream stream = new ADNameSampleStream((ObjectStream)new PlainTextByLineStream(this.in, StandardCharsets.UTF_8), true);){
            NameSample sample;
            while ((sample = stream.read()) != null) {
                this.samples.add(sample);
            }
        }
    }

    @Test
    void testSimpleCount() {
        Assertions.assertEquals((int)8, (int)this.samples.size());
    }

    @Test
    void testCheckMergedContractions() {
        Assertions.assertEquals((Object)"no", (Object)((NameSample)this.samples.get(0)).getSentence()[1]);
        Assertions.assertEquals((Object)"no", (Object)((NameSample)this.samples.get(0)).getSentence()[11]);
        Assertions.assertEquals((Object)"Com", (Object)((NameSample)this.samples.get(1)).getSentence()[0]);
        Assertions.assertEquals((Object)"rela\u00e7\u00e3o", (Object)((NameSample)this.samples.get(1)).getSentence()[1]);
        Assertions.assertEquals((Object)"\u00e0", (Object)((NameSample)this.samples.get(1)).getSentence()[2]);
        Assertions.assertEquals((Object)"mais", (Object)((NameSample)this.samples.get(2)).getSentence()[4]);
        Assertions.assertEquals((Object)"de", (Object)((NameSample)this.samples.get(2)).getSentence()[5]);
        Assertions.assertEquals((Object)"da", (Object)((NameSample)this.samples.get(2)).getSentence()[8]);
        Assertions.assertEquals((Object)"num", (Object)((NameSample)this.samples.get(3)).getSentence()[26]);
    }

    @Test
    void testSize() {
        Assertions.assertEquals((int)25, (int)((NameSample)this.samples.get(0)).getSentence().length);
        Assertions.assertEquals((int)12, (int)((NameSample)this.samples.get(1)).getSentence().length);
        Assertions.assertEquals((int)59, (int)((NameSample)this.samples.get(2)).getSentence().length);
        Assertions.assertEquals((int)33, (int)((NameSample)this.samples.get(3)).getSentence().length);
    }

    @Test
    void testNames() {
        Assertions.assertEquals((Object)new Span(4, 7, "time"), (Object)((NameSample)this.samples.get(0)).getNames()[0]);
        Assertions.assertEquals((Object)new Span(8, 10, "place"), (Object)((NameSample)this.samples.get(0)).getNames()[1]);
        Assertions.assertEquals((Object)new Span(12, 14, "place"), (Object)((NameSample)this.samples.get(0)).getNames()[2]);
        Assertions.assertEquals((Object)new Span(15, 17, "person"), (Object)((NameSample)this.samples.get(0)).getNames()[3]);
        Assertions.assertEquals((Object)new Span(18, 19, "numeric"), (Object)((NameSample)this.samples.get(0)).getNames()[4]);
        Assertions.assertEquals((Object)new Span(20, 22, "place"), (Object)((NameSample)this.samples.get(0)).getNames()[5]);
        Assertions.assertEquals((Object)new Span(23, 24, "place"), (Object)((NameSample)this.samples.get(0)).getNames()[6]);
        Assertions.assertEquals((Object)new Span(22, 24, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[0]);
        Assertions.assertEquals((Object)new Span(25, 27, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[1]);
        Assertions.assertEquals((Object)new Span(28, 30, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[2]);
        Assertions.assertEquals((Object)new Span(31, 34, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[3]);
        Assertions.assertEquals((Object)new Span(35, 37, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[4]);
        Assertions.assertEquals((Object)new Span(38, 40, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[5]);
        Assertions.assertEquals((Object)new Span(41, 43, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[6]);
        Assertions.assertEquals((Object)new Span(44, 46, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[7]);
        Assertions.assertEquals((Object)new Span(47, 49, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[8]);
        Assertions.assertEquals((Object)new Span(50, 52, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[9]);
        Assertions.assertEquals((Object)new Span(53, 55, "person"), (Object)((NameSample)this.samples.get(2)).getNames()[10]);
        Assertions.assertEquals((Object)new Span(0, 1, "place"), (Object)((NameSample)this.samples.get(3)).getNames()[0]);
        Assertions.assertEquals((Object)new Span(6, 7, "event"), (Object)((NameSample)this.samples.get(3)).getNames()[1]);
        Assertions.assertEquals((Object)new Span(15, 16, "organization"), (Object)((NameSample)this.samples.get(3)).getNames()[2]);
        Assertions.assertEquals((Object)new Span(18, 19, "event"), (Object)((NameSample)this.samples.get(3)).getNames()[3]);
        Assertions.assertEquals((Object)new Span(27, 28, "event"), (Object)((NameSample)this.samples.get(3)).getNames()[4]);
        Assertions.assertEquals((Object)new Span(29, 30, "event"), (Object)((NameSample)this.samples.get(3)).getNames()[5]);
        Assertions.assertEquals((Object)new Span(1, 6, "time"), (Object)((NameSample)this.samples.get(4)).getNames()[0]);
        Assertions.assertEquals((Object)new Span(0, 3, "person"), (Object)((NameSample)this.samples.get(5)).getNames()[0]);
    }

    @Test
    void testSmallSentence() {
        Assertions.assertEquals((int)2, (int)((NameSample)this.samples.get(6)).getSentence().length);
    }

    @Test
    void testMissingRightContraction() {
        Assertions.assertEquals((Object)new Span(0, 1, "person"), (Object)((NameSample)this.samples.get(7)).getNames()[0]);
        Assertions.assertEquals((Object)new Span(3, 4, "person"), (Object)((NameSample)this.samples.get(7)).getNames()[1]);
        Assertions.assertEquals((Object)new Span(5, 6, "person"), (Object)((NameSample)this.samples.get(7)).getNames()[2]);
    }
}

