/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.formats.ad.ADChunkSampleStream;
import opennlp.tools.formats.ad.AbstractADSampleStreamTest;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ADChunkSampleStreamTest
extends AbstractADSampleStreamTest<ChunkSample> {
    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
        try (ADChunkSampleStream stream = new ADChunkSampleStream((ObjectStream)new PlainTextByLineStream(this.in, StandardCharsets.UTF_8));){
            ChunkSample sample;
            while ((sample = stream.read()) != null) {
                this.samples.add(sample);
            }
            Assertions.assertFalse((boolean)this.samples.isEmpty());
        }
    }

    @Test
    void testSimpleCount() {
        Assertions.assertEquals((int)8, (int)this.samples.size());
    }

    @Test
    void testChunks() {
        Assertions.assertEquals((Object)"Inicia", (Object)((ChunkSample)this.samples.get(0)).getSentence()[0]);
        Assertions.assertEquals((Object)"v-fin", (Object)((ChunkSample)this.samples.get(0)).getTags()[0]);
        Assertions.assertEquals((Object)"B-VP", (Object)((ChunkSample)this.samples.get(0)).getPreds()[0]);
        Assertions.assertEquals((Object)"em", (Object)((ChunkSample)this.samples.get(0)).getSentence()[1]);
        Assertions.assertEquals((Object)"prp", (Object)((ChunkSample)this.samples.get(0)).getTags()[1]);
        Assertions.assertEquals((Object)"B-PP", (Object)((ChunkSample)this.samples.get(0)).getPreds()[1]);
        Assertions.assertEquals((Object)"o", (Object)((ChunkSample)this.samples.get(0)).getSentence()[2]);
        Assertions.assertEquals((Object)"art", (Object)((ChunkSample)this.samples.get(0)).getTags()[2]);
        Assertions.assertEquals((Object)"B-NP", (Object)((ChunkSample)this.samples.get(0)).getPreds()[2]);
        Assertions.assertEquals((Object)"pr\u00f3ximo", (Object)((ChunkSample)this.samples.get(0)).getSentence()[3]);
        Assertions.assertEquals((Object)"adj", (Object)((ChunkSample)this.samples.get(0)).getTags()[3]);
        Assertions.assertEquals((Object)"I-NP", (Object)((ChunkSample)this.samples.get(0)).getPreds()[3]);
        Assertions.assertEquals((Object)"Casas", (Object)((ChunkSample)this.samples.get(3)).getSentence()[0]);
        Assertions.assertEquals((Object)"n", (Object)((ChunkSample)this.samples.get(3)).getTags()[0]);
        Assertions.assertEquals((Object)"B-NP", (Object)((ChunkSample)this.samples.get(3)).getPreds()[0]);
    }
}

