/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ad.ADChunkSampleStreamFactory;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ADChunkSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<ChunkSample, ADChunkSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "ad.sample";
    private ADChunkSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<ChunkSample, ADChunkSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ADChunkSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(ChunkSample.class, (String)"ad");
        Assertions.assertInstanceOf(ADChunkSampleStreamFactory.class, (Object)f);
        this.factory = (ADChunkSampleStreamFactory)f;
        Assertions.assertEquals(ADChunkSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/ad/ad.sample").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-start", "0", "-end", "1", "-lang", "por", "-encoding", "UTF-8", "-data", this.sampleFileFullPath});){
            ChunkSample sample = (ChunkSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-start", "0", "-end", "1", "-lang", "por", "-encoding", "UTF-8", "-data", this.sampleFileFullPath + "xyz"});){
                ChunkSample sample = (ChunkSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

