/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.WordTagSampleStreamFactory;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WordTagSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<POSSample, WordTagSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "word-tags-01.sample";
    private WordTagSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<POSSample, WordTagSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        WordTagSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(POSSample.class, (String)"opennlp");
        Assertions.assertInstanceOf(WordTagSampleStreamFactory.class, (Object)f);
        this.factory = (WordTagSampleStreamFactory)f;
        Assertions.assertEquals(WordTagSampleStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/word-tags-01.sample").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-data", this.sampleFileFullPath});){
            POSSample sample = (POSSample)stream.read();
            Assertions.assertNotNull((Object)sample);
            Assertions.assertNotNull((Object)sample.getTags());
            Assertions.assertEquals((int)6, (int)sample.getTags().length);
            Assertions.assertNotNull((Object)sample.getSentence());
            Assertions.assertEquals((int)6, (int)sample.getSentence().length);
        }
    }
}

