/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.TwentyNewsgroupSampleStreamFactory;
import opennlp.tools.models.ModelType;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EmptySource;
import org.junit.jupiter.params.provider.ValueSource;

public class TwentyNewsgroupSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<DocumentSample, TwentyNewsgroupSampleStreamFactory.Parameters> {
    private static final Path OPENNLP_DIR = Paths.get(System.getProperty("OPENNLP_DOWNLOAD_HOME", System.getProperty("user.home")), new String[0]).resolve(".opennlp");
    private static final String TOKENIZER_MODEL_NAME = "opennlp-en-ud-ewt-tokens-1.3-2.5.4.bin";
    private TwentyNewsgroupSampleStreamFactory factory;
    private static String tokFileFullPath;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<DocumentSample, TwentyNewsgroupSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        TwentyNewsgroupSampleStreamFactory.registerFactory();
        try {
            DownloadUtil.downloadModel((String)"en", (ModelType)ModelType.TOKENIZER, TokenizerModel.class);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getLocalizedMessage());
        }
        tokFileFullPath = new File(String.valueOf(OPENNLP_DIR) + File.separator + TOKENIZER_MODEL_NAME).getPath();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(DocumentSample.class, (String)"20newsgroup");
        Assertions.assertInstanceOf(TwentyNewsgroupSampleStreamFactory.class, (Object)f);
        this.factory = (TwentyNewsgroupSampleStreamFactory)f;
        Assertions.assertEquals(TwentyNewsgroupSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/20newsgroup").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"simple", "whitespace"})
    void testCreateWithValidParameter(String tokenizerType) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-ruleBasedTokenizer", tokenizerType, "-dataDir", this.sampleFileFullPath});){
            DocumentSample sample = (DocumentSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @ParameterizedTest
    @EmptySource
    @ValueSource(strings={" ", "unknown"})
    void testCreateWithInvalidRBTokenizer(String tokenizerType) {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-ruleBasedTokenizer", tokenizerType, "-dataDir", this.sampleFileFullPath});){
                DocumentSample sample = (DocumentSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Test
    void testCreateWithMETokenizer() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-tokenizerModel", tokFileFullPath, "-dataDir", this.sampleFileFullPath});){
            DocumentSample sample = (DocumentSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @ParameterizedTest
    @EmptySource
    @ValueSource(strings={" ", "unknown"})
    void testCreateWithInvalidMETokenizer(String path) {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-tokenizerModel", path, "-dataDir", this.sampleFileFullPath});){
                DocumentSample sample = (DocumentSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-ruleBasedTokenizer", "whitespace", "-dataDir", this.sampleFileFullPath + "xyz"});){
                DocumentSample sample = (DocumentSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

