/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ParseSampleStreamFactory;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ParseSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<Parse, ParseSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "parse-01.sample";
    private ParseSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<Parse, ParseSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ParseSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(Parse.class, (String)"opennlp");
        Assertions.assertInstanceOf(ParseSampleStreamFactory.class, (Object)f);
        this.factory = (ParseSampleStreamFactory)f;
        Assertions.assertEquals(ParseSampleStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/parse-01.sample").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-data", this.sampleFileFullPath});){
            Parse sample = (Parse)stream.read();
            Assertions.assertNotNull((Object)sample);
            Assertions.assertEquals((Object)"The test shall come today . ", (Object)sample.getText());
        }
    }
}

