/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.NameSampleDataStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NameSampleDataStreamFactoryTest
extends AbstractSampleStreamFactoryTest<NameSample, NameSampleDataStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "name-data-01.sample";
    private NameSampleDataStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<NameSample, NameSampleDataStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        NameSampleDataStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(NameSample.class, (String)"opennlp");
        Assertions.assertInstanceOf(NameSampleDataStreamFactory.class, (Object)f);
        this.factory = (NameSampleDataStreamFactory)f;
        Assertions.assertEquals(NameSampleDataStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/name-data-01.sample").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-data", this.sampleFileFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
            Span[] hits = sample.getNames();
            Assertions.assertNotNull((Object)hits);
            Assertions.assertEquals((int)1, (int)hits.length);
            Assertions.assertEquals((int)5, (int)hits[0].getStart());
            Assertions.assertEquals((int)6, (int)hits[0].getEnd());
        }
    }
}

