/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.util.stream.Stream;
import opennlp.tools.formats.AbstractSampleStreamTest;
import opennlp.tools.formats.EvalitaNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class EvalitaNameSampleStreamTest
extends AbstractSampleStreamTest {
    private static final String SAMPLE_01 = "evalita-ner-it-01.sample";
    private static final String SAMPLE_02 = "evalita-ner-it-02.sample";
    private static final String SAMPLE_03 = "evalita-ner-it-03.sample";
    private static final String SAMPLE_BROKEN = "evalita-ner-it-broken.sample";
    private static final String SAMPLE_INCORRECT = "evalita-ner-it-incorrect.sample";

    @ParameterizedTest
    @MethodSource(value={"provideData"})
    void testReadItalianDifferentEntityTypes(String file, int nerType, int expectedSentLength, int expectedStart, int expectedEnd) throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(file, nerType);){
            NameSample ne = (NameSample)sampleStream.read();
            Assertions.assertNotNull((Object)ne);
            Assertions.assertEquals((int)expectedSentLength, (int)ne.getSentence().length);
            Assertions.assertEquals((int)1, (int)ne.getNames().length);
            Assertions.assertTrue((boolean)ne.isClearAdaptiveDataSet());
            Span nameSpan = ne.getNames()[0];
            Assertions.assertEquals((int)expectedStart, (int)nameSpan.getStart());
            Assertions.assertEquals((int)expectedEnd, (int)nameSpan.getEnd());
            Assertions.assertTrue((boolean)ne.isClearAdaptiveDataSet());
            if (SAMPLE_01.equals(file)) {
                Assertions.assertEquals((int)0, (int)((NameSample)sampleStream.read()).getNames().length);
            }
            Assertions.assertNull((Object)sampleStream.read());
        }
    }

    @Test
    void testReadWithIncorrectInput() {
        Assertions.assertThrows(IOException.class, () -> {
            try (ObjectStream<NameSample> sampleStream = this.openData(SAMPLE_INCORRECT, 1);){
                sampleStream.read();
            }
        });
    }

    @Test
    void testReadWithBrokenDocument() {
        Assertions.assertThrows(IOException.class, () -> {
            try (ObjectStream<NameSample> sampleStream = this.openData(SAMPLE_BROKEN, 1);){
                sampleStream.read();
            }
        });
    }

    @Test
    void testReset() throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(SAMPLE_01, 1);){
            NameSample sample = (NameSample)sampleStream.read();
            sampleStream.reset();
            Assertions.assertEquals((Object)sample, (Object)sampleStream.read());
        }
    }

    public static Stream<Arguments> provideData() {
        return Stream.of(Arguments.of((Object[])new Object[]{SAMPLE_01, 1, 11, 8, 10}), Arguments.of((Object[])new Object[]{SAMPLE_02, 1, 27, 11, 13}), Arguments.of((Object[])new Object[]{SAMPLE_02, 2, 27, 10, 11}), Arguments.of((Object[])new Object[]{SAMPLE_03, 8, 20, 18, 19}));
    }

    private ObjectStream<NameSample> openData(String fileName, int nerType) throws IOException {
        return new EvalitaNameSampleStream(EvalitaNameSampleStream.LANGUAGE.IT, this.getFactory(fileName), nerType);
    }
}

