/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.EvalitaNameSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EvalitaNameSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<NameSample, EvalitaNameSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "evalita-ner-it-01.sample";
    private EvalitaNameSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<NameSample, EvalitaNameSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        EvalitaNameSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(NameSample.class, (String)"evalita");
        Assertions.assertInstanceOf(EvalitaNameSampleStreamFactory.class, (Object)f);
        this.factory = (EvalitaNameSampleStreamFactory)f;
        Assertions.assertEquals(EvalitaNameSampleStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/evalita-ner-it-01.sample").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-lang", "it", "-types", "per,loc,org,gpe", "-data", this.sampleFileFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Test
    void testCreateWithInvalidLanguage() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-lang", "xy", "-types", "per,loc,org,gpe", "-data", this.sampleFileFullPath});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-lang", "it", "-types", "per,loc,org,gpe", "-data", this.sampleFileFullPath + "xyz"});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

