/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.UUID;
import opennlp.tools.AbstractTempDirTest;
import opennlp.tools.formats.DirectorySampleStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DirectorySampleStreamTest
extends AbstractTempDirTest {
    private FileFilter filter;

    @BeforeEach
    public void setup() {
        this.filter = new TempFileNameFilter();
    }

    @Test
    public void directoryTest() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File temp1 = this.createTempFile();
        files.add(temp1);
        File temp2 = this.createTempFile();
        files.add(temp2);
        DirectorySampleStream stream = new DirectorySampleStream(this.tempDir.toFile(), this.filter, false);
        File file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertNull((Object)file);
        stream.close();
    }

    @Test
    public void directoryNullFilterTest() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File temp1 = this.createTempFile();
        files.add(temp1);
        File temp2 = this.createTempFile();
        files.add(temp2);
        DirectorySampleStream stream = new DirectorySampleStream(this.tempDir.toFile(), null, false);
        File file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertNull((Object)file);
        stream.close();
    }

    @Test
    public void recursiveDirectoryTest() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File temp1 = this.createTempFile();
        files.add(temp1);
        File tempSubDirectory = this.createTempFolder("sub1");
        File temp2 = Files.createTempFile(tempSubDirectory.toPath(), "sub1", ".tmp", new FileAttribute[0]).toFile();
        files.add(temp2);
        DirectorySampleStream stream = new DirectorySampleStream(this.tempDir.toFile(), this.filter, true);
        File file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertNull((Object)file);
        stream.close();
    }

    @Test
    public void resetDirectoryTest() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File temp1 = this.createTempFile();
        files.add(temp1);
        File temp2 = this.createTempFile();
        files.add(temp2);
        DirectorySampleStream stream = new DirectorySampleStream(this.tempDir.toFile(), this.filter, false);
        File file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        stream.reset();
        file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertTrue((boolean)files.contains(file));
        file = stream.read();
        Assertions.assertNull((Object)file);
        stream.close();
    }

    @Test
    public void emptyDirectoryTest() throws IOException {
        DirectorySampleStream stream = new DirectorySampleStream(this.tempDir.toFile(), this.filter, false);
        Assertions.assertNull((Object)stream.read());
        stream.close();
    }

    @Test
    public void invalidDirectoryTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            TempFileNameFilter filter = new TempFileNameFilter();
            DirectorySampleStream stream = new DirectorySampleStream(this.createTempFile(), (FileFilter)filter, false);
            Assertions.assertNull((Object)stream.read());
            stream.close();
        });
    }

    private File createTempFolder(String name) {
        Path subDir = this.tempDir.resolve(name);
        try {
            Files.createDirectory(subDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create sub directory " + subDir.toFile().getAbsolutePath(), e);
        }
        return subDir.toFile();
    }

    private File createTempFile() {
        Path tempFile = this.tempDir.resolve(String.valueOf(UUID.randomUUID()) + ".tmp");
        try {
            Files.createFile(tempFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create file " + tempFile.toFile().getAbsolutePath(), e);
        }
        return tempFile.toFile();
    }

    static class TempFileNameFilter
    implements FileFilter {
        TempFileNameFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".tmp");
        }
    }
}

