/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ConllXSentenceSampleStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConllXSentenceSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<SentenceSample, ConllXSentenceSampleStreamFactory.Parameters> {
    private static final String DETOKENIZER_FILE = "opennlp/tools/tokenize/latin-detokenizer.xml";
    private static final String SAMPLE_01 = "conllx.sample";
    private ConllXSentenceSampleStreamFactory factory;
    private String detokFileFullPath;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<SentenceSample, ConllXSentenceSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ConllXSentenceSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(SentenceSample.class, (String)"conllx");
        Assertions.assertInstanceOf(ConllXSentenceSampleStreamFactory.class, (Object)f);
        this.factory = (ConllXSentenceSampleStreamFactory)f;
        Assertions.assertEquals(ConllXSentenceSampleStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/conllx.sample").getPath();
        this.detokFileFullPath = this.getResourceWithoutPrefix(DETOKENIZER_FILE).getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-encoding", "UTF-8", "-detokenizer", this.detokFileFullPath, "-data", this.sampleFileFullPath});){
            SentenceSample sample = (SentenceSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-encoding", "UTF-8", "-detokenizer", this.detokFileFullPath, "-data", this.sampleFileFullPath + "xyz"});){
                SentenceSample sample = (SentenceSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

