/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ConllXPOSSampleStreamFactory;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConllXPOSSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<POSSample, ConllXPOSSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "conllx.sample";
    private ConllXPOSSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<POSSample, ConllXPOSSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ConllXPOSSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(POSSample.class, (String)"conllx");
        Assertions.assertInstanceOf(ConllXPOSSampleStreamFactory.class, (Object)f);
        this.factory = (ConllXPOSSampleStreamFactory)f;
        Assertions.assertEquals(ConllXPOSSampleStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/conllx.sample").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-data", this.sampleFileFullPath});){
            POSSample sample = (POSSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }
}

