/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.formats.AbstractSampleStreamTest;
import opennlp.tools.formats.Conll03NameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Conll03NameSampleStreamTest
extends AbstractSampleStreamTest {
    private static final String ENGLISH_SAMPLE = "conll2003-en.sample";
    private static final String GERMAN_SAMPLE = "conll2003-de.sample";

    @Test
    void testParsingEnglishSample() throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(Conll03NameSampleStream.LANGUAGE.EN, ENGLISH_SAMPLE);){
            NameSample personName = (NameSample)sampleStream.read();
            Assertions.assertNotNull((Object)personName);
            Assertions.assertEquals((int)9, (int)personName.getSentence().length);
            Assertions.assertEquals((int)0, (int)personName.getNames().length);
            Assertions.assertTrue((boolean)personName.isClearAdaptiveDataSet());
            personName = (NameSample)sampleStream.read();
            Assertions.assertNotNull((Object)personName);
            Assertions.assertEquals((int)2, (int)personName.getSentence().length);
            Assertions.assertEquals((int)1, (int)personName.getNames().length);
            Assertions.assertFalse((boolean)personName.isClearAdaptiveDataSet());
            Span nameSpan = personName.getNames()[0];
            Assertions.assertEquals((int)0, (int)nameSpan.getStart());
            Assertions.assertEquals((int)2, (int)nameSpan.getEnd());
            Assertions.assertNull((Object)sampleStream.read());
        }
    }

    @Test
    void testParsingEnglishSampleWithGermanAsLanguage() {
        Assertions.assertThrows(IOException.class, () -> {
            ObjectStream<NameSample> sampleStream = this.openData(Conll03NameSampleStream.LANGUAGE.DE, ENGLISH_SAMPLE);
            sampleStream.read();
        });
    }

    @Test
    void testParsingGermanSampleWithEnglishAsLanguage() {
        Assertions.assertThrows(IOException.class, () -> {
            ObjectStream<NameSample> sampleStream = this.openData(Conll03NameSampleStream.LANGUAGE.EN, GERMAN_SAMPLE);
            sampleStream.read();
        });
    }

    @Test
    void testParsingGermanSample() throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(Conll03NameSampleStream.LANGUAGE.DE, GERMAN_SAMPLE);){
            NameSample personName = (NameSample)sampleStream.read();
            Assertions.assertNotNull((Object)personName);
            Assertions.assertEquals((int)5, (int)personName.getSentence().length);
            Assertions.assertEquals((int)0, (int)personName.getNames().length);
            Assertions.assertTrue((boolean)personName.isClearAdaptiveDataSet());
        }
    }

    @Test
    void testReset() throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(Conll03NameSampleStream.LANGUAGE.DE, GERMAN_SAMPLE);){
            NameSample sample = (NameSample)sampleStream.read();
            sampleStream.reset();
            Assertions.assertEquals((Object)sample, (Object)sampleStream.read());
        }
    }

    private ObjectStream<NameSample> openData(Conll03NameSampleStream.LANGUAGE lang, String name) throws IOException {
        return new Conll03NameSampleStream(lang, this.getFactory(name), 1);
    }
}

