/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.Conll03NameSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class Conll03NameSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<NameSample, Conll03NameSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "conll2003-de.sample";
    private static final String SAMPLE_02 = "conll2003-en.sample";
    private Conll03NameSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<NameSample, Conll03NameSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        Conll03NameSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(NameSample.class, (String)"conll03");
        Assertions.assertInstanceOf(Conll03NameSampleStreamFactory.class, (Object)f);
        this.factory = (Conll03NameSampleStreamFactory)f;
        Assertions.assertEquals(Conll03NameSampleStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/conll2003-de.sample").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"deu", "eng"})
    void testCreateWithValidParameter(String lang) throws IOException {
        this.sampleFileFullPath = "deu".equals(lang) ? this.getResourceWithoutPrefix("opennlp/tools/formats/conll2003-de.sample").getPath() : this.getResourceWithoutPrefix("opennlp/tools/formats/conll2003-en.sample").getPath();
        try (ObjectStream stream = this.factory.create(new String[]{"-lang", lang, "-types", "per,loc,org,misc", "-data", this.sampleFileFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"", "per", "loc", "org", "misc", "per,loc,org,misc"})
    void testCreateWithDifferentTypes(String types) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-lang", "deu", "-types", types, "-data", this.sampleFileFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Test
    void testCreateWithInvalidLanguage() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-lang", "xyz", "-types", "per,loc,org,misc", "-data", this.sampleFileFullPath});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-lang", "deu", "-types", "per,loc,org,misc", "-data", this.sampleFileFullPath + "xyz"});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

