/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.formats.AbstractSampleStreamTest;
import opennlp.tools.formats.Conll02NameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Conll02NameSampleStreamTest
extends AbstractSampleStreamTest {
    @Test
    void testParsingSpanishSample() throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(Conll02NameSampleStream.LANGUAGE.SPA, "conll2002-es.sample");){
            NameSample personName = (NameSample)sampleStream.read();
            Assertions.assertNotNull((Object)personName);
            Assertions.assertEquals((int)5, (int)personName.getSentence().length);
            Assertions.assertEquals((int)1, (int)personName.getNames().length);
            Assertions.assertTrue((boolean)personName.isClearAdaptiveDataSet());
            Span nameSpan = personName.getNames()[0];
            Assertions.assertEquals((int)0, (int)nameSpan.getStart());
            Assertions.assertEquals((int)4, (int)nameSpan.getEnd());
            Assertions.assertTrue((boolean)personName.isClearAdaptiveDataSet());
            Assertions.assertEquals((int)0, (int)((NameSample)sampleStream.read()).getNames().length);
            Assertions.assertNull((Object)sampleStream.read());
        }
    }

    @Test
    void testParsingDutchSample() throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(Conll02NameSampleStream.LANGUAGE.NLD, "conll2002-nl.sample");){
            NameSample personName = (NameSample)sampleStream.read();
            Assertions.assertEquals((int)0, (int)personName.getNames().length);
            Assertions.assertTrue((boolean)personName.isClearAdaptiveDataSet());
            personName = (NameSample)sampleStream.read();
            Assertions.assertFalse((boolean)personName.isClearAdaptiveDataSet());
            Assertions.assertNull((Object)sampleStream.read());
        }
    }

    @Test
    void testReset() throws IOException {
        try (ObjectStream<NameSample> sampleStream = this.openData(Conll02NameSampleStream.LANGUAGE.NLD, "conll2002-nl.sample");){
            NameSample sample = (NameSample)sampleStream.read();
            sampleStream.reset();
            Assertions.assertEquals((Object)sample, (Object)sampleStream.read());
        }
    }

    private ObjectStream<NameSample> openData(Conll02NameSampleStream.LANGUAGE lang, String name) throws IOException {
        return new Conll02NameSampleStream(lang, this.getFactory(name), 1);
    }
}

