/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.BioNLP2004NameSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BioNLP2004NameSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<NameSample, BioNLP2004NameSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "bionlp2004-01.sample";
    private BioNLP2004NameSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<NameSample, BioNLP2004NameSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        BioNLP2004NameSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(NameSample.class, (String)"bionlp2004");
        Assertions.assertInstanceOf(BioNLP2004NameSampleStreamFactory.class, (Object)f);
        this.factory = (BioNLP2004NameSampleStreamFactory)f;
        Assertions.assertEquals(BioNLP2004NameSampleStreamFactory.Parameters.class, (Object)this.factory.params);
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/bionlp2004-01.sample").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-types", "DNA,protein,cell_type,cell_line,RNA", "-data", this.sampleFileFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
            Assertions.assertEquals((int)5, (int)sample.getNames().length);
            Assertions.assertEquals((Object)"protein", (Object)sample.getNames()[0].getType());
            Assertions.assertEquals((Object)"protein", (Object)sample.getNames()[1].getType());
            Assertions.assertEquals((Object)"protein", (Object)sample.getNames()[2].getType());
            Assertions.assertEquals((Object)"protein", (Object)sample.getNames()[3].getType());
            Assertions.assertEquals((Object)"cell_type", (Object)sample.getNames()[4].getType());
        }
    }

    @Test
    void testCreateWithUnsupportedTypes() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-types", "xyz", "-data", this.sampleFileFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-types", "DNA,protein,cell_type,cell_line,RNA", "-data", this.sampleFileFullPath + "xyz"});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

