/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractFormatTest;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSampleStreamFactoryTest<S, P>
extends AbstractFormatTest {
    protected static final String FORMAT_SAMPLE_DIR = "opennlp/tools/formats/";

    protected abstract AbstractSampleStreamFactory<S, P> getFactory();

    protected abstract String getDataFilePath();

    @Test
    void testCreateWithNullParameter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (ObjectStream stream = this.getFactory().create(null);){
                stream.read();
            }
        });
    }

    @Test
    void testCreateWithInvalidParameter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (ObjectStream stream = this.getFactory().create(new String[]{"X"});){
                stream.read();
            }
        });
    }

    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.getFactory().create(new String[]{"-data", this.getDataFilePath() + "xyz"});){
                Object sample = stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

