/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.formats.conllu.ConlluLemmaSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.lemmatizer.Lemmatizer;
import opennlp.tools.lemmatizer.LemmatizerEvaluationMonitor;
import opennlp.tools.lemmatizer.LemmatizerEvaluator;
import opennlp.tools.lemmatizer.LemmatizerFactory;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class UniversalDependency20Eval
extends AbstractEvalTest {
    private static File SPA_ANCORA_TRAIN;
    private static File SPA_ANCORA_DEV;

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        SPA_ANCORA_TRAIN = new File(UniversalDependency20Eval.getOpennlpDataDir(), "ud20/UD_Spanish-AnCora/es_ancora-ud-train.conllu");
        SPA_ANCORA_DEV = new File(UniversalDependency20Eval.getOpennlpDataDir(), "ud20/UD_Spanish-AnCora/es_ancora-ud-dev.conllu");
        UniversalDependency20Eval.verifyFileChecksum(SPA_ANCORA_TRAIN.toPath(), new BigInteger("224942804200733453179524127037951530195"));
        UniversalDependency20Eval.verifyFileChecksum(SPA_ANCORA_DEV.toPath(), new BigInteger("280996187464384493180190898172297941708"));
    }

    private double trainAndEval(String lang, File trainFile, TrainingParameters params, File evalFile) throws IOException {
        ConlluTagset tagset = ConlluTagset.X;
        ConlluLemmaSampleStream trainSamples = new ConlluLemmaSampleStream((ObjectStream)new ConlluStream((InputStreamFactory)new MarkableFileInputStreamFactory(trainFile)), tagset);
        LemmatizerModel model = LemmatizerME.train((String)lang, (ObjectStream)trainSamples, (TrainingParameters)params, (LemmatizerFactory)new LemmatizerFactory());
        LemmatizerEvaluator evaluator = new LemmatizerEvaluator((Lemmatizer)new LemmatizerME(model), new LemmatizerEvaluationMonitor[0]);
        evaluator.evaluate((ObjectStream)new ConlluLemmaSampleStream((ObjectStream)new ConlluStream((InputStreamFactory)new MarkableFileInputStreamFactory(evalFile)), tagset));
        return evaluator.getWordAccuracy();
    }

    @Test
    void trainAndEvalSpanishAncora() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Threads", "4");
        double wordAccuracy = this.trainAndEval("spa", SPA_ANCORA_TRAIN, params, SPA_ANCORA_DEV);
        Assertions.assertEquals((double)0.9057341692068787, (double)wordAccuracy, (double)1.0E-4);
    }
}

