/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.stemmer.snowball.SnowballStemmer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class SnowballTokenizerEval
extends AbstractEvalTest {
    @ParameterizedTest
    @EnumSource(value=SnowballStemmer.ALGORITHM.class)
    public void test(SnowballStemmer.ALGORITHM lang) throws IOException {
        List<String> vocabulary = this.getData(lang, "voc.txt");
        List<String> expectedOutputs = this.getData(lang, "output.txt");
        Assertions.assertEquals((int)vocabulary.size(), (int)expectedOutputs.size(), (String)"Expected equally sized lists.");
        SnowballStemmer stemmer = new SnowballStemmer(lang);
        for (int i = 0; i < vocabulary.size(); ++i) {
            String word = vocabulary.get(i);
            String stem = expectedOutputs.get(i);
            Assertions.assertEquals((Object)stem, (Object)stemmer.stem((CharSequence)word));
        }
    }

    private List<String> getData(SnowballStemmer.ALGORITHM lang, String name) throws IOException {
        Path expectedOutput = this.getSnowballDataLanguagePath(this.getSnowballDataPath(), lang).resolve(name);
        return Files.readAllLines(expectedOutput);
    }

    private Path getSnowballDataPath() throws FileNotFoundException {
        return SnowballTokenizerEval.getOpennlpDataDir().toPath().resolve("snowball-data");
    }

    private Path getSnowballDataLanguagePath(Path root, SnowballStemmer.ALGORITHM lang) {
        return root.resolve(lang.toString().toLowerCase(Locale.ROOT));
    }
}

