/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.convert.ParseToPOSSampleStream;
import opennlp.tools.formats.ontonotes.DocumentToLineStream;
import opennlp.tools.formats.ontonotes.OntoNotesParseSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTagFormat;
import opennlp.tools.postag.POSTaggerCrossValidator;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class OntoNotes4PosTaggerEval
extends AbstractEvalTest {
    private static ObjectStream<POSSample> createPOSSampleStream() throws IOException {
        DirectorySampleStream documentStream = new DirectorySampleStream(new File(OntoNotes4PosTaggerEval.getOpennlpDataDir(), "ontonotes4/data/files/data/english"), file -> {
            if (file.isFile()) {
                return file.getName().endsWith(".parse");
            }
            return file.isDirectory();
        }, true);
        return new ParseToPOSSampleStream((ObjectStream)new OntoNotesParseSampleStream((ObjectStream)new DocumentToLineStream((ObjectStream)new FileToStringSampleStream((ObjectStream)documentStream, StandardCharsets.UTF_8))));
    }

    private void crossEval(TrainingParameters params, double expectedScore) throws IOException {
        try (ObjectStream<POSSample> samples = OntoNotes4PosTaggerEval.createPOSSampleStream();){
            POSTaggerCrossValidator cv = new POSTaggerCrossValidator("eng", params, new POSTaggerFactory(), POSTagFormat.PENN, new POSTaggerEvaluationMonitor[0]);
            cv.evaluate(samples, 5);
            Assertions.assertEquals((double)expectedScore, (double)cv.getWordAccuracy(), (double)1.0E-4);
        }
    }

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        OntoNotes4PosTaggerEval.verifyTrainingData(OntoNotes4PosTaggerEval.createPOSSampleStream(), new BigInteger("300430765214895870888056958221353356972"));
    }

    @Test
    void evalEnglishMaxentTagger() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Threads", "4");
        this.crossEval(params, 0.969345319453096);
    }
}

