/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.ontonotes.DocumentToLineStream;
import opennlp.tools.formats.ontonotes.OntoNotesParseSampleStream;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserCrossValidator;
import opennlp.tools.parser.ParserEvaluationMonitor;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.parser.lang.en.HeadRulesTest;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class OntoNotes4ParserEval
extends AbstractEvalTest {
    private static ObjectStream<Parse> createParseSampleStream() throws IOException {
        DirectorySampleStream documentStream = new DirectorySampleStream(new File(OntoNotes4ParserEval.getOpennlpDataDir(), "ontonotes4/data/files/data/english"), file -> {
            if (file.isFile()) {
                return file.getName().endsWith(".parse");
            }
            return file.isDirectory();
        }, true);
        return new OntoNotesParseSampleStream((ObjectStream)new DocumentToLineStream((ObjectStream)new FileToStringSampleStream((ObjectStream)documentStream, StandardCharsets.UTF_8)));
    }

    private void crossEval(TrainingParameters params, opennlp.tools.parser.HeadRules rules, double expectedScore) throws IOException {
        try (ObjectStream<Parse> samples = OntoNotes4ParserEval.createParseSampleStream();){
            ParserCrossValidator cv = new ParserCrossValidator("eng", params, rules, ParserType.CHUNKING, new ParserEvaluationMonitor[0]);
            cv.evaluate(samples, 5);
            Assertions.assertEquals((double)expectedScore, (double)cv.getFMeasure().getFMeasure(), (double)1.0E-4);
        }
    }

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        OntoNotes4ParserEval.verifyTrainingData(OntoNotes4ParserEval.createParseSampleStream(), new BigInteger("83833369887442127665956850482411800415"));
    }

    @Test
    void evalEnglishMaxent() throws IOException {
        HeadRules headRules;
        try (InputStream headRulesIn = HeadRulesTest.class.getResourceAsStream("/opennlp/tools/parser/en_head_rules");){
            headRules = new HeadRules((Reader)new InputStreamReader(headRulesIn, StandardCharsets.UTF_8));
        }
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("build.Threads", 4);
        params.put("tagger.Threads", 4);
        params.put("chunker.Threads", 4);
        params.put("check.Threads", 4);
        this.crossEval(params, (opennlp.tools.parser.HeadRules)headRules, 0.9373673649973432);
    }
}

