/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.ontonotes.OntoNotesNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderCrossValidator;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class OntoNotes4NameFinderEval
extends AbstractEvalTest {
    private static ObjectStream<NameSample> createNameSampleStream() throws IOException {
        DirectorySampleStream documentStream = new DirectorySampleStream(new File(OntoNotes4NameFinderEval.getOpennlpDataDir(), "ontonotes4/data/files/data/english"), file -> {
            if (file.isFile()) {
                return file.getName().endsWith(".name");
            }
            return file.isDirectory();
        }, true);
        return new OntoNotesNameSampleStream((ObjectStream)new FileToStringSampleStream((ObjectStream)documentStream, StandardCharsets.UTF_8));
    }

    private void crossEval(TrainingParameters params, String type, double expectedScore) throws IOException {
        try (NameSampleTypeFilter samples = OntoNotes4NameFinderEval.createNameSampleStream();){
            TokenNameFinderCrossValidator cv = new TokenNameFinderCrossValidator("eng", null, params, new TokenNameFinderFactory(), new TokenNameFinderEvaluationMonitor[0]);
            NameSampleTypeFilter filteredSamples = type != null ? new NameSampleTypeFilter(new String[]{type}, samples) : samples;
            cv.evaluate(filteredSamples, 5);
            Assertions.assertEquals((double)expectedScore, (double)cv.getFMeasure().getFMeasure(), (double)0.001);
        }
    }

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        OntoNotes4NameFinderEval.verifyDirectoryChecksum(new File(OntoNotes4NameFinderEval.getOpennlpDataDir(), "ontonotes4/data/files/data/english").toPath(), ".name", new BigInteger("74675117716526375898817028829433420680"));
    }

    @Test
    void evalEnglishPersonNameFinder() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Threads", "4");
        this.crossEval(params, "person", 0.822014580552418);
    }

    @Test
    void evalEnglishDateNameFinder() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Threads", "4");
        this.crossEval(params, "date", 0.8043873255040994);
    }

    @Test
    void evalAllTypesNameFinder() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Threads", "4");
        this.crossEval(params, null, 0.8014054850253551);
    }

    @Test
    void evalAllTypesWithPOSNameFinder() throws IOException, URISyntaxException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Threads", "4");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (InputStream in = this.getClass().getResourceAsStream("ner-en_pos-features.xml");){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                bytes.write(buf, 0, len);
            }
        }
        byte[] featureGen = bytes.toByteArray();
        Path resourcesPath = Files.createTempDirectory("opennlp_resources", new FileAttribute[0]);
        Files.copy(new File(OntoNotes4NameFinderEval.getOpennlpDataDir(), "models-sf/en-pos-perceptron.bin").toPath(), new File(resourcesPath.toFile(), "en-pos-perceptron.bin").toPath(), StandardCopyOption.REPLACE_EXISTING);
        Map resources = TokenNameFinderTrainerTool.loadResources((File)resourcesPath.toFile(), (File)Paths.get(this.getClass().getResource("ner-en_pos-features.xml").toURI()).toFile());
        try (ObjectStream<NameSample> samples = OntoNotes4NameFinderEval.createNameSampleStream();){
            TokenNameFinderCrossValidator cv = new TokenNameFinderCrossValidator("eng", null, params, featureGen, resources, new TokenNameFinderEvaluationMonitor[0]);
            ObjectStream<NameSample> filteredSamples = samples;
            cv.evaluate(filteredSamples, 5);
            Assertions.assertEquals((double)0.8070226153653437, (double)cv.getFMeasure().getFMeasure(), (double)0.001);
        }
    }
}

