/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.ThreadSafePOSTaggerME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.ThreadSafeSentenceDetectorME;
import opennlp.tools.tokenize.ThreadSafeTokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Test;

public class MultiThreadedToolsEval
extends AbstractEvalTest {
    @Test
    public void runMEToolsMultiThreaded() throws IOException, InterruptedException {
        File dataDir = MultiThreadedToolsEval.getOpennlpDataDir();
        File sModelFile = new File(dataDir, "models-sf/en-sent.bin");
        File tModelFile = new File(dataDir, "models-sf/en-token.bin");
        File pModelFile = new File(dataDir, "models-sf/en-pos-maxent.bin");
        SentenceModel sModel = new SentenceModel(sModelFile);
        TokenizerModel tModel = new TokenizerModel(tModelFile);
        POSModel pModel = new POSModel(pModelFile);
        try (ThreadSafeSentenceDetectorME sentencer = new ThreadSafeSentenceDetectorME(sModel);
             ThreadSafeTokenizerME tokenizer = new ThreadSafeTokenizerME(tModel);
             ThreadSafePOSTaggerME tagger = new ThreadSafePOSTaggerME(pModel);){
            String text = "All human beings are born free and equal in dignity and rights. They are endowed with reason and conscience and should act towards one another in a spirit of brotherhood.";
            int numThreads = 8;
            int numRunsPerThread = 1000;
            Thread[] threads = new Thread[8];
            for (int i = 0; i < 8; ++i) {
                threads[i] = new Thread(() -> {
                    for (int j = 0; j < 1000; ++j) {
                        Span[] sentences;
                        for (Span span : sentences = sentencer.sentPosDetect((CharSequence)"All human beings are born free and equal in dignity and rights. They are endowed with reason and conscience and should act towards one another in a spirit of brotherhood.")) {
                            String sentence = "All human beings are born free and equal in dignity and rights. They are endowed with reason and conscience and should act towards one another in a spirit of brotherhood.".substring(span.getStart(), span.getEnd());
                            Span[] tokens = tokenizer.tokenizePos(sentence);
                            String[] tokenStrings = new String[tokens.length];
                            for (int k = 0; k < tokens.length; ++k) {
                                tokenStrings[k] = sentence.substring(tokens[k].getStart(), tokens[k].getEnd());
                            }
                            String[] stringArray = tagger.tag(tokenStrings);
                        }
                    }
                });
                threads[i].start();
            }
            for (Thread t : threads) {
                t.join();
            }
        }
    }
}

