/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import opennlp.tools.HighMemoryUsage;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.formats.ConllXPOSSampleStream;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagFormat;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ConllXPosTaggerEval
extends AbstractEvalTest {
    private POSModel train(File trainFile, String lang, TrainingParameters params) throws IOException {
        ConllXPOSSampleStream samples = new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(trainFile), StandardCharsets.UTF_8);
        return POSTaggerME.train((String)lang, (ObjectStream)samples, (TrainingParameters)params, (POSTaggerFactory)new POSTaggerFactory());
    }

    private void eval(POSModel model, File testData, double expectedAccuracy) throws IOException {
        ConllXPOSSampleStream samples = new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(testData), StandardCharsets.UTF_8);
        POSEvaluator evaluator = new POSEvaluator((POSTagger)new POSTaggerME(model, POSTagFormat.PENN), new POSTaggerEvaluationMonitor[0]);
        evaluator.evaluate((ObjectStream)samples);
        Assertions.assertEquals((double)expectedAccuracy, (double)evaluator.getWordAccuracy(), (double)1.0E-4);
    }

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        ConllXPosTaggerEval.verifyTrainingData(new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/danish/ddt/train/danish_ddt_train.conll")), StandardCharsets.UTF_8), new BigInteger("30795670444498617202001550516753630016"));
        ConllXPosTaggerEval.verifyTrainingData(new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/danish/ddt/test/danish_ddt_test.conll")), StandardCharsets.UTF_8), new BigInteger("314104267846430512372780024568104131337"));
        ConllXPosTaggerEval.verifyTrainingData(new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/dutch/alpino/train/dutch_alpino_train.conll")), StandardCharsets.UTF_8), new BigInteger("109328245573060521952850454797286933887"));
        ConllXPosTaggerEval.verifyTrainingData(new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/dutch/alpino/test/dutch_alpino_test.conll")), StandardCharsets.UTF_8), new BigInteger("132343141132816640849897155456916243039"));
        ConllXPosTaggerEval.verifyTrainingData(new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/portuguese/bosque/treebank/portuguese_bosque_train.conll")), StandardCharsets.UTF_8), new BigInteger("9504382474772307801979515927230835901"));
        ConllXPosTaggerEval.verifyTrainingData(new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/swedish/talbanken05/train/swedish_talbanken05_train.conll")), StandardCharsets.UTF_8), new BigInteger("175256039869578311901318972681191182910"));
        ConllXPosTaggerEval.verifyTrainingData(new ConllXPOSSampleStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/swedish/talbanken05/test/swedish_talbanken05_test.conll")), StandardCharsets.UTF_8), new BigInteger("128378790384268106811747599235147991544"));
    }

    @Test
    void evalDanishMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/danish/ddt/train/danish_ddt_train.conll"), "dan", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/danish/ddt/test/danish_ddt_test.conll"), 0.9504442925495558);
    }

    @Test
    void evalDanishMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/danish/ddt/train/danish_ddt_train.conll"), "dan", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/danish/ddt/test/danish_ddt_test.conll"), 0.9564251537935748);
    }

    @Test
    void evalDutchMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/dutch/alpino/train/dutch_alpino_train.conll"), "nld", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/dutch/alpino/test/dutch_alpino_test.conll"), 0.9213965980304387);
    }

    @Test
    @HighMemoryUsage
    void evalDutchMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/dutch/alpino/train/dutch_alpino_train.conll"), "nld", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/dutch/alpino/test/dutch_alpino_test.conll"), 0.9282005371530886);
    }

    @Test
    void evalPortugueseMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/portuguese/bosque/treebank/portuguese_bosque_train.conll"), "por", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/portuguese/bosque/test/portuguese_bosque_test.conll"), 0.9671041418101244);
    }

    @Test
    void evalPortugueseMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/portuguese/bosque/treebank/portuguese_bosque_train.conll"), "por", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/portuguese/bosque/test/portuguese_bosque_test.conll"), 0.9662519175046872);
    }

    @Test
    void evalSwedishMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/swedish/talbanken05/train/swedish_talbanken05_train.conll"), "swe", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/swedish/talbanken05/test/swedish_talbanken05_test.conll"), 0.9248585572842999);
    }

    @Test
    void evalSwedishMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        POSModel maxentModel = this.train(new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/swedish/talbanken05/train/swedish_talbanken05_train.conll"), "swe", params);
        this.eval(maxentModel, new File(ConllXPosTaggerEval.getOpennlpDataDir(), "conllx/data/swedish/talbanken05/test/swedish_talbanken05_test.conll"), 0.9377652050919377);
    }
}

