/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.formats.Conll02NameSampleStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class Conll02NameFinderEval
extends AbstractEvalTest {
    private static File dutchTrainingFile;
    private static File dutchTestAFile;
    private static File dutchTestBFile;
    private static File spanishTrainingFile;
    private static File spanishTestAFile;
    private static File spanishTestBFile;

    private TokenNameFinderModel train(File trainFile, Conll02NameSampleStream.LANGUAGE lang, TrainingParameters params, int types) throws IOException {
        Conll02NameSampleStream samples = new Conll02NameSampleStream(lang, (InputStreamFactory)new MarkableFileInputStreamFactory(trainFile), types);
        return NameFinderME.train((String)lang.toString().toLowerCase(), null, (ObjectStream)samples, (TrainingParameters)params, (TokenNameFinderFactory)new TokenNameFinderFactory());
    }

    private void eval(TokenNameFinderModel model, File testData, Conll02NameSampleStream.LANGUAGE lang, int types, double expectedFMeasure) throws IOException {
        Conll02NameSampleStream samples = new Conll02NameSampleStream(lang, (InputStreamFactory)new MarkableFileInputStreamFactory(testData), types);
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator((TokenNameFinder)new NameFinderME(model), new TokenNameFinderEvaluationMonitor[0]);
        evaluator.evaluate((ObjectStream)samples);
        Assertions.assertEquals((double)expectedFMeasure, (double)evaluator.getFMeasure().getFMeasure(), (double)1.0E-4);
    }

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        dutchTrainingFile = new File(Conll02NameFinderEval.getOpennlpDataDir(), "conll02/ner/data/ned.train");
        dutchTestAFile = new File(Conll02NameFinderEval.getOpennlpDataDir(), "conll02/ner/data/ned.testa");
        dutchTestBFile = new File(Conll02NameFinderEval.getOpennlpDataDir(), "conll02/ner/data/ned.testb");
        spanishTrainingFile = new File(Conll02NameFinderEval.getOpennlpDataDir(), "conll02/ner/data/esp.train");
        spanishTestAFile = new File(Conll02NameFinderEval.getOpennlpDataDir(), "conll02/ner/data/esp.testa");
        spanishTestBFile = new File(Conll02NameFinderEval.getOpennlpDataDir(), "conll02/ner/data/esp.testb");
        Conll02NameFinderEval.verifyTrainingData(new Conll02NameSampleStream(Conll02NameSampleStream.LANGUAGE.NLD, (InputStreamFactory)new MarkableFileInputStreamFactory(dutchTrainingFile), 1), new BigInteger("244586345524636491735310529744396558541"));
        Conll02NameFinderEval.verifyTrainingData(new Conll02NameSampleStream(Conll02NameSampleStream.LANGUAGE.NLD, (InputStreamFactory)new MarkableFileInputStreamFactory(dutchTestAFile), 1), new BigInteger("246627484906192029575077493716150690762"));
        Conll02NameFinderEval.verifyTrainingData(new Conll02NameSampleStream(Conll02NameSampleStream.LANGUAGE.NLD, (InputStreamFactory)new MarkableFileInputStreamFactory(dutchTestBFile), 1), new BigInteger("160341129860513958203421820548607024932"));
        Conll02NameFinderEval.verifyTrainingData(new Conll02NameSampleStream(Conll02NameSampleStream.LANGUAGE.SPA, (InputStreamFactory)new MarkableFileInputStreamFactory(spanishTrainingFile), 1), new BigInteger("77622870982561669762102345960336466598"));
        Conll02NameFinderEval.verifyTrainingData(new Conll02NameSampleStream(Conll02NameSampleStream.LANGUAGE.SPA, (InputStreamFactory)new MarkableFileInputStreamFactory(spanishTestAFile), 1), new BigInteger("143641744095673112729040601949871621359"));
        Conll02NameFinderEval.verifyTrainingData(new Conll02NameSampleStream(Conll02NameSampleStream.LANGUAGE.SPA, (InputStreamFactory)new MarkableFileInputStreamFactory(spanishTestBFile), 1), new BigInteger("91310271319593094243555094042436157393"));
    }

    @Test
    void evalDutchPersonPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 1);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 1, 0.6590308370044053);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 1, 0.7396672034353193);
    }

    @Test
    void evalDutchPersonMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 1);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 1, 0.5691489361702128);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 1, 0.7148891235480465);
    }

    @Test
    void evalDutchPersonMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 1);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 1, 0.6356311548791406);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 1, 0.7458533975387909);
    }

    @Test
    void evalDutchOrganizationPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 2);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 2, 0.6289549376797698);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 2, 0.6498245614035087);
    }

    @Test
    void evalDutchOrganizationMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 2);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 2, 0.5197969543147207);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 2, 0.5716342692584593);
    }

    @Test
    void evalDutchOrganizationMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 2);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 2, 0.5851703406813628);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 2, 0.6089466089466089);
    }

    @Test
    void evalDutchLocationPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 4);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 4, 0.7887005649717513);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 4, 0.7943859649122806);
    }

    @Test
    void evalDutchLocationMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 4);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 4, 0.564673157162726);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 4, 0.6835443037974683);
    }

    @Test
    void evalDutchLocationMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 4);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 4, 0.6711229946524064);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 4, 0.738993710691824);
    }

    @Test
    void evalDutchMiscPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 8);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 8, 0.6676691729323307);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 8, 0.6711345141215893);
    }

    @Test
    void evalDutchMiscMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 8);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 8, 0.5831157528285466);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 8, 0.5755079626578803);
    }

    @Test
    void evalDutchMiscMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, 8);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, 8, 0.5965858041329739);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, 8, 0.5876993166287016);
    }

    @Test
    void evalDutchCombinedPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        int combinedType = 15;
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, combinedType);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, combinedType, 0.7170923379174853);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, combinedType, 0.7442767950052028);
    }

    @Test
    void evalDutchCombinedMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        int combinedType = 15;
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, combinedType);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, combinedType, 0.6687585801137477);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, combinedType, 0.699353169469599);
    }

    @Test
    void evalDutchCombinedMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        int combinedType = 15;
        TokenNameFinderModel maxentModel = this.train(dutchTrainingFile, Conll02NameSampleStream.LANGUAGE.NLD, params, combinedType);
        this.eval(maxentModel, dutchTestAFile, Conll02NameSampleStream.LANGUAGE.NLD, combinedType, 0.7084501401682018);
        this.eval(maxentModel, dutchTestBFile, Conll02NameSampleStream.LANGUAGE.NLD, combinedType, 0.7370923015977816);
    }

    @Test
    void evalSpanishPersonPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 1);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 1, 0.8177509694097371);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 1, 0.8438928804702809);
    }

    @Test
    void evalSpanishPersonMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 1);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 1, 0.684263959390863);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 1, 0.8142532221379833);
    }

    @Test
    void evalSpanishPersonMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 1);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 1, 0.7399014778325124);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 1, 0.8282977155490052);
    }

    @Test
    void evalSpanishOrganizationPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 2);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 2, 0.7406759906759908);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 2, 0.7764471057884231);
    }

    @Test
    void evalSpanishOrganizationMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 2);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 2, 0.6988771691051379);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 2, 0.7638680659670164);
    }

    @Test
    void evalSpanishOrganizationMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 2);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 2, 0.6921985815602836);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 2, 0.7797548438117834);
    }

    @Test
    void evalSpanishLocationPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 4);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 4, 0.7156983930778738);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 4, 0.6361474435196195);
    }

    @Test
    void evalSpanishLocationMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 4);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 4, 0.7376263970196913);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 4, 0.6746987951807228);
    }

    @Test
    void evalSpanishLocationMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 4);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 4, 0.7463726059199071);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 4, 0.6772727272727272);
    }

    @Test
    void evalSpanishMiscPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 8);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 8, 0.5020352781546812);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 8, 0.5703564727954972);
    }

    @Test
    void evalSpanishMiscMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 8);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 8, 0.4176829268292683);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 8, 0.461839530332681);
    }

    @Test
    void evalSpanishMiscMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, 8);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, 8, 0.478395061728395);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, 8, 0.5153374233128835);
    }

    @Test
    void evalSpanishCombinedPerceptron() throws IOException {
        TrainingParameters params = this.createPerceptronParams();
        int combinedType = 15;
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, combinedType);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, combinedType, 0.7383003492433061);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, combinedType, 0.748207507380852);
    }

    @Test
    void evalSpanishCombinedMaxentGis() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        int combinedType = 15;
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, combinedType);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, combinedType, 0.7060201452330757);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, combinedType, 0.7549668874172185);
    }

    @Test
    void evalSpanishCombinedMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        int combinedType = 15;
        TokenNameFinderModel maxentModel = this.train(spanishTrainingFile, Conll02NameSampleStream.LANGUAGE.SPA, params, combinedType);
        this.eval(maxentModel, spanishTestAFile, Conll02NameSampleStream.LANGUAGE.SPA, combinedType, 0.7204819277108434);
        this.eval(maxentModel, spanishTestBFile, Conll02NameSampleStream.LANGUAGE.SPA, combinedType, 0.7514002585092633);
    }
}

