/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import opennlp.tools.HighMemoryUsage;
import opennlp.tools.chunker.ChunkSampleStream;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class Conll00ChunkerEval
extends AbstractEvalTest {
    private static File TEST_DATA_FILE;
    private static File TRAIN_DATA_FILE;

    private static ChunkerModel train(File trainFile, TrainingParameters params) throws IOException {
        ChunkSampleStream samples = new ChunkSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MarkableFileInputStreamFactory(trainFile), StandardCharsets.UTF_8));
        return ChunkerME.train((String)"eng", (ObjectStream)samples, (TrainingParameters)params, (ChunkerFactory)new ChunkerFactory());
    }

    private static void eval(ChunkerModel model, File testData, double expectedFMeasure) throws IOException {
        ChunkSampleStream samples = new ChunkSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MarkableFileInputStreamFactory(testData), StandardCharsets.UTF_8));
        ChunkerEvaluator evaluator = new ChunkerEvaluator((Chunker)new ChunkerME(model), new ChunkerEvaluationMonitor[0]);
        evaluator.evaluate((ObjectStream)samples);
        Assertions.assertEquals((double)expectedFMeasure, (double)evaluator.getFMeasure().getFMeasure(), (double)1.0E-4);
    }

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        TEST_DATA_FILE = new File(Conll00ChunkerEval.getOpennlpDataDir(), "conll00/test.txt");
        TRAIN_DATA_FILE = new File(Conll00ChunkerEval.getOpennlpDataDir(), "conll00/train.txt");
        Conll00ChunkerEval.verifyTrainingData(new ChunkSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MarkableFileInputStreamFactory(TEST_DATA_FILE), StandardCharsets.UTF_8)), new BigInteger("84610235226433393380477662908529306002"));
        Conll00ChunkerEval.verifyTrainingData(new ChunkSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MarkableFileInputStreamFactory(TEST_DATA_FILE), StandardCharsets.UTF_8)), new BigInteger("84610235226433393380477662908529306002"));
    }

    @Test
    void evalEnglishPerceptron() throws IOException {
        ChunkerModel maxentModel = Conll00ChunkerEval.train(TRAIN_DATA_FILE, this.createPerceptronParams());
        Conll00ChunkerEval.eval(maxentModel, TEST_DATA_FILE, 0.9295018353434714);
    }

    @Test
    void evalEnglishMaxentGis() throws IOException {
        ChunkerModel maxentModel = Conll00ChunkerEval.train(TRAIN_DATA_FILE, ModelUtil.createDefaultTrainingParameters());
        Conll00ChunkerEval.eval(maxentModel, TEST_DATA_FILE, 0.9239687473746113);
    }

    @Test
    @HighMemoryUsage
    void evalEnglishMaxentQn() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        params.put("Threads", 4);
        ChunkerModel maxentModel = Conll00ChunkerEval.train(TRAIN_DATA_FILE, params);
        Conll00ChunkerEval.eval(maxentModel, TEST_DATA_FILE, 0.9302599230947028);
    }
}

