/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import opennlp.tools.chunker.ChunkerCrossValidator;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.eval.AbstractEvalTest;
import opennlp.tools.formats.ad.ADChunkSampleStream;
import opennlp.tools.formats.ad.ADNameSampleStream;
import opennlp.tools.formats.ad.ADSentenceSampleStream;
import opennlp.tools.formats.convert.NameToTokenSampleStream;
import opennlp.tools.sentdetect.SDCrossValidator;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.lang.Factory;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.tokenize.TokenizerCrossValidator;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ArvoresDeitadasEval
extends AbstractEvalTest {
    private static final String BOSQUE = "ad/Bosque_CF_8.0.ad.txt";
    private static final String FLORESTA_VIRGEM = "ad/FlorestaVirgem_CF_3.0_ad.txt";
    private static final String LANG = "por";

    private static ObjectStream<String> getLineSample(String corpus) throws IOException {
        return new PlainTextByLineStream((InputStreamFactory)new MarkableFileInputStreamFactory(new File(ArvoresDeitadasEval.getOpennlpDataDir(), corpus)), StandardCharsets.ISO_8859_1);
    }

    @BeforeAll
    static void verifyTrainingData() throws Exception {
        ArvoresDeitadasEval.verifyTrainingData(new ADSentenceSampleStream(ArvoresDeitadasEval.getLineSample(BOSQUE), false), new BigInteger("140568367548727787313497336739085858596"));
        ArvoresDeitadasEval.verifyTrainingData(new ADSentenceSampleStream(ArvoresDeitadasEval.getLineSample(FLORESTA_VIRGEM), false), new BigInteger("2614161133949079191933514776652602918"));
    }

    private void sentenceCrossEval(TrainingParameters params, double expectedScore) throws IOException {
        ADSentenceSampleStream samples = new ADSentenceSampleStream(ArvoresDeitadasEval.getLineSample(FLORESTA_VIRGEM), false);
        SDCrossValidator cv = new SDCrossValidator(LANG, params, new SentenceDetectorFactory(LANG, true, null, new Factory().getEOSCharacters(LANG)), new SentenceDetectorEvaluationMonitor[0]);
        cv.evaluate((ObjectStream)samples, 10);
        Assertions.assertEquals((double)expectedScore, (double)cv.getFMeasure().getFMeasure(), (double)1.0E-4);
    }

    private void tokenizerCrossEval(TrainingParameters params, double expectedScore) throws IOException {
        ADNameSampleStream nameSamples = new ADNameSampleStream(ArvoresDeitadasEval.getLineSample(FLORESTA_VIRGEM), true);
        DictionaryDetokenizer detokenizer = new DictionaryDetokenizer(new DetokenizationDictionary(new File("lang/pt/tokenizer/pt-detokenizer.xml")));
        NameToTokenSampleStream samples = new NameToTokenSampleStream((Detokenizer)detokenizer, (ObjectStream)nameSamples);
        TokenizerFactory tokFactory = TokenizerFactory.create(null, (String)LANG, null, (boolean)true, null);
        TokenizerCrossValidator validator = new TokenizerCrossValidator(params, tokFactory, new TokenizerEvaluationMonitor[0]);
        validator.evaluate((ObjectStream)samples, 10);
        Assertions.assertEquals((double)expectedScore, (double)validator.getFMeasure().getFMeasure(), (double)1.0E-4);
    }

    private void chunkerCrossEval(TrainingParameters params, double expectedScore) throws IOException {
        ADChunkSampleStream samples = new ADChunkSampleStream(ArvoresDeitadasEval.getLineSample(BOSQUE));
        ChunkerCrossValidator cv = new ChunkerCrossValidator(LANG, params, new ChunkerFactory(), new ChunkerEvaluationMonitor[0]);
        cv.evaluate((ObjectStream)samples, 10);
        Assertions.assertEquals((double)expectedScore, (double)cv.getFMeasure().getFMeasure(), (double)1.0E-4);
    }

    @Test
    void evalPortugueseSentenceDetectorPerceptron() throws IOException {
        this.sentenceCrossEval(this.createPerceptronParams(), 0.9892778840089301);
    }

    @Test
    void evalPortugueseSentenceDetectorGis() throws IOException {
        this.sentenceCrossEval(ModelUtil.createDefaultTrainingParameters(), 0.987270070655111);
    }

    @Test
    void evalPortugueseSentenceDetectorMaxentQn() throws IOException {
        this.sentenceCrossEval(this.createMaxentQnParams(), 0.9924715809679968);
    }

    @Test
    void evalPortugueseSentenceDetectorNaiveBayes() throws IOException {
        this.sentenceCrossEval(this.createNaiveBayesParams(), 0.9672196206048099);
    }

    @Test
    void evalPortugueseTokenizerPerceptron() throws IOException {
        this.tokenizerCrossEval(this.createPerceptronParams(), 0.9994887308380267);
    }

    @Test
    void evalPortugueseTokenizerGis() throws IOException {
        this.tokenizerCrossEval(ModelUtil.createDefaultTrainingParameters(), 0.9992539405481062);
    }

    @Test
    void evalPortugueseTokenizerMaxentQn() throws IOException {
        this.tokenizerCrossEval(this.createMaxentQnParams(), 0.9996017148748251);
    }

    @Test
    void evalPortugueseTokenizerNaiveBayes() throws IOException {
        this.tokenizerCrossEval(this.createNaiveBayesParams(), 0.9962358244502717);
    }

    @Test
    void evalPortugueseTokenizerMaxentQnMultipleThreads() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        params.put("Threads", 4);
        this.tokenizerCrossEval(params, 0.9996017148748251);
    }

    @Test
    void evalPortugueseChunkerPerceptron() throws IOException {
        this.chunkerCrossEval(this.createPerceptronParams(), 0.9631066789979492);
    }

    @Test
    void evalPortugueseChunkerGis() throws IOException {
        this.chunkerCrossEval(ModelUtil.createDefaultTrainingParameters(), 0.9571790438663504);
    }

    @Test
    void evalPortugueseChunkerGisMultipleThreads() throws IOException {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Threads", 4);
        this.chunkerCrossEval(params, 0.9571790438663504);
    }

    @Test
    void evalPortugueseChunkerQn() throws IOException {
        this.chunkerCrossEval(this.createMaxentQnParams(), 0.9655574076677446);
    }

    @Test
    void evalPortugueseChunkerQnMultipleThreads() throws IOException {
        TrainingParameters params = this.createMaxentQnParams();
        params.put("Threads", 4);
        this.chunkerCrossEval(params, 0.9655858045209428);
    }

    @Test
    void evalPortugueseChunkerNaiveBayes() throws IOException {
        this.chunkerCrossEval(this.createNaiveBayesParams(), 0.9041507736043933);
    }
}

