/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.eval;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.List;
import java.util.stream.Collectors;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractEvalTest {
    public static final double ACCURACY_DELTA = 1.0E-4;
    public static final String HASH_ALGORITHM = "MD5";

    public static void verifyTrainingData(ObjectStream<?> samples, BigInteger checksum) throws Exception {
        Object sample;
        MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
        while ((sample = samples.read()) != null) {
            digest.update(sample.toString().getBytes(StandardCharsets.UTF_8));
        }
        samples.close();
        Assertions.assertEquals((Object)checksum, (Object)new BigInteger(1, digest.digest()));
    }

    public static void verifyFileChecksum(Path file, BigInteger checksum) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            int len;
            byte[] buf = new byte[65536];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                digest.update(buf, 0, len);
            }
        }
        Assertions.assertEquals((Object)checksum, (Object)new BigInteger(1, digest.digest()));
    }

    public static void verifyDirectoryChecksum(Path path, String extension, BigInteger checksum) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
        List paths = Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(extension)).sorted().collect(Collectors.toList());
        for (Path p2 : paths) {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(p2, new OpenOption[0]));){
                int len;
                byte[] buf = new byte[65536];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    digest.update(buf, 0, len);
                }
            }
        }
        Assertions.assertEquals((Object)checksum, (Object)new BigInteger(1, digest.digest()));
    }

    public static File getOpennlpDataDir() throws FileNotFoundException {
        String dataDirectory = System.getProperty("OPENNLP_DATA_DIR");
        if (dataDirectory == null || dataDirectory.isBlank()) {
            throw new IllegalArgumentException("The OPENNLP_DATA_DIR is not set.");
        }
        File file = new File(System.getProperty("OPENNLP_DATA_DIR"));
        if (!file.exists()) {
            throw new FileNotFoundException("The OPENNLP_DATA_DIR path of " + dataDirectory + " was not found.");
        }
        return file;
    }

    public TrainingParameters createPerceptronParams() {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Algorithm", "PERCEPTRON");
        params.put("Cutoff", 0);
        return params;
    }

    public TrainingParameters createMaxentQnParams() {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Algorithm", "MAXENT_QN");
        params.put("Cutoff", 0);
        return params;
    }

    public TrainingParameters createNaiveBayesParams() {
        TrainingParameters params = ModelUtil.createDefaultTrainingParameters();
        params.put("Algorithm", "NAIVEBAYES");
        params.put("Cutoff", 5);
        return params;
    }
}

