/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.Collections;
import opennlp.tools.doccat.NGramFeatureGenerator;
import opennlp.tools.util.InvalidFormatException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NGramFeatureGeneratorTest {
    static final String[] TOKENS = new String[]{"a", "b", "c", "d", "e", "f", "g"};

    @Test
    void testNull() throws Exception {
        NGramFeatureGenerator generator = new NGramFeatureGenerator();
        try {
            generator.extractFeatures(null, Collections.emptyMap());
            Assertions.fail((String)"NullPointerException must be thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    void testEmpty() throws Exception {
        NGramFeatureGenerator generator = new NGramFeatureGenerator();
        Assertions.assertEquals((int)0, (int)generator.extractFeatures(new String[0], Collections.emptyMap()).size());
    }

    @Test
    void testInvalidGramSize1() {
        try {
            new NGramFeatureGenerator(0, 1);
            Assertions.fail((String)"InvalidFormatException must be thrown");
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    @Test
    void testInvalidGramSize2() {
        try {
            new NGramFeatureGenerator(2, 1);
            Assertions.fail((String)"InvalidFormatException must be thrown");
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    @Test
    void testUnigram() throws Exception {
        NGramFeatureGenerator generator = new NGramFeatureGenerator(1, 1);
        Assertions.assertArrayEquals((Object[])new String[]{"ng=:a", "ng=:b", "ng=:c", "ng=:d", "ng=:e", "ng=:f", "ng=:g"}, (Object[])generator.extractFeatures(TOKENS, Collections.emptyMap()).toArray());
    }

    @Test
    void testBigram() throws Exception {
        NGramFeatureGenerator generator = new NGramFeatureGenerator(2, 2);
        Assertions.assertArrayEquals((Object[])new String[]{"ng=:a:b", "ng=:b:c", "ng=:c:d", "ng=:d:e", "ng=:e:f", "ng=:f:g"}, (Object[])generator.extractFeatures(TOKENS, Collections.emptyMap()).toArray());
    }

    @Test
    void testTrigram() throws Exception {
        NGramFeatureGenerator generator = new NGramFeatureGenerator(3, 3);
        Assertions.assertArrayEquals((Object[])new String[]{"ng=:a:b:c", "ng=:b:c:d", "ng=:c:d:e", "ng=:d:e:f", "ng=:e:f:g"}, (Object[])generator.extractFeatures(TOKENS, Collections.emptyMap()).toArray());
    }

    @Test
    void test12gram() throws Exception {
        NGramFeatureGenerator generator = new NGramFeatureGenerator(1, 2);
        Assertions.assertArrayEquals((Object[])new String[]{"ng=:a", "ng=:a:b", "ng=:b", "ng=:b:c", "ng=:c", "ng=:c:d", "ng=:d", "ng=:d:e", "ng=:e", "ng=:e:f", "ng=:f", "ng=:f:g", "ng=:g"}, (Object[])generator.extractFeatures(TOKENS, Collections.emptyMap()).toArray());
    }

    @Test
    void test13gram() throws Exception {
        NGramFeatureGenerator generator = new NGramFeatureGenerator(1, 3);
        Assertions.assertArrayEquals((Object[])new String[]{"ng=:a", "ng=:a:b", "ng=:a:b:c", "ng=:b", "ng=:b:c", "ng=:b:c:d", "ng=:c", "ng=:c:d", "ng=:c:d:e", "ng=:d", "ng=:d:e", "ng=:d:e:f", "ng=:e", "ng=:e:f", "ng=:e:f:g", "ng=:f", "ng=:f:g", "ng=:g"}, (Object[])generator.extractFeatures(TOKENS, Collections.emptyMap()).toArray());
    }
}

