/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import opennlp.tools.doccat.DocumentSample;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentSampleTest {
    @Test
    void testEquals() {
        Assertions.assertNotSame((Object)DocumentSampleTest.createGoldSample(), (Object)DocumentSampleTest.createGoldSample());
        Assertions.assertEquals((Object)DocumentSampleTest.createGoldSample(), (Object)DocumentSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)DocumentSampleTest.createPredSample(), (Object)DocumentSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)new Object(), (Object)DocumentSampleTest.createPredSample());
    }

    @Test
    void testDocumentSampleSerDe() throws IOException {
        DocumentSample documentSample = DocumentSampleTest.createGoldSample();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(documentSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        DocumentSample deSerializedDocumentSample = null;
        try {
            deSerializedDocumentSample = (DocumentSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedDocumentSample);
        Assertions.assertEquals((Object)documentSample.getCategory(), (Object)deSerializedDocumentSample.getCategory());
        Assertions.assertArrayEquals((Object[])documentSample.getText(), (Object[])deSerializedDocumentSample.getText());
    }

    public static DocumentSample createGoldSample() {
        return new DocumentSample("aCategory", new String[]{"a", "small", "text"});
    }

    public static DocumentSample createPredSample() {
        return new DocumentSample("anotherCategory", new String[]{"a", "small", "text"});
    }
}

