/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.IOException;
import java.util.Set;
import java.util.SortedMap;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentCategorizerMETest {
    @Test
    void testSimpleTraining() throws IOException {
        ObjectStream samples = ObjectStreamUtils.createObjectStream((Object[])new DocumentSample[]{new DocumentSample("1", new String[]{"a", "b", "c"}), new DocumentSample("1", new String[]{"a", "b", "c", "1", "2"}), new DocumentSample("1", new String[]{"a", "b", "c", "3", "4"}), new DocumentSample("0", new String[]{"x", "y", "z"}), new DocumentSample("0", new String[]{"x", "y", "z", "5", "6"}), new DocumentSample("0", new String[]{"x", "y", "z", "7", "8"})});
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 100);
        params.put("Cutoff", 0);
        DoccatModel model = DocumentCategorizerME.train((String)"x-unspecified", (ObjectStream)samples, (TrainingParameters)params, (DoccatFactory)new DoccatFactory());
        DocumentCategorizerME doccat = new DocumentCategorizerME(model);
        double[] aProbs = doccat.categorize(new String[]{"a"});
        Assertions.assertEquals((Object)"1", (Object)doccat.getBestCategory(aProbs));
        double[] bProbs = doccat.categorize(new String[]{"x"});
        Assertions.assertEquals((Object)"0", (Object)doccat.getBestCategory(bProbs));
        SortedMap sortedScoreMap = doccat.sortedScoreMap(new String[]{"a"});
        Set cat = (Set)sortedScoreMap.get(sortedScoreMap.lastKey());
        Assertions.assertEquals((int)1, (int)cat.size());
    }

    @Test
    void insufficientTestData() {
        Assertions.assertThrows(InsufficientTrainingDataException.class, () -> {
            ObjectStream samples = ObjectStreamUtils.createObjectStream((Object[])new DocumentSample[]{new DocumentSample("1", new String[]{"a", "b", "c"})});
            TrainingParameters params = new TrainingParameters();
            params.put("Iterations", 100);
            params.put("Cutoff", 0);
            DocumentCategorizerME.train((String)"x-unspecified", (ObjectStream)samples, (TrainingParameters)params, (DoccatFactory)new DoccatFactory());
        });
    }
}

