/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.DocumentSampleStream;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.doccat.NGramFeatureGenerator;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DoccatFactoryTest {
    private static ObjectStream<DocumentSample> createSampleStream() throws IOException {
        ResourceAsStreamFactory isf = new ResourceAsStreamFactory(DoccatFactoryTest.class, "/opennlp/tools/doccat/DoccatSample.txt");
        return new DocumentSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)isf, StandardCharsets.UTF_8));
    }

    private static DoccatModel train() throws IOException {
        return DocumentCategorizerME.train((String)"x-unspecified", DoccatFactoryTest.createSampleStream(), (TrainingParameters)TrainingParameters.defaultParams(), (DoccatFactory)new DoccatFactory());
    }

    private static DoccatModel train(DoccatFactory factory) throws IOException {
        return DocumentCategorizerME.train((String)"x-unspecified", DoccatFactoryTest.createSampleStream(), (TrainingParameters)TrainingParameters.defaultParams(), (DoccatFactory)factory);
    }

    @Test
    void testDefault() throws IOException {
        DoccatModel model = DoccatFactoryTest.train();
        Assertions.assertNotNull((Object)model);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        DoccatModel fromSerialized = new DoccatModel((InputStream)in);
        DoccatFactory factory = fromSerialized.getFactory();
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals((int)1, (int)factory.getFeatureGenerators().length);
        Assertions.assertEquals(BagOfWordsFeatureGenerator.class, factory.getFeatureGenerators()[0].getClass());
    }

    @Test
    void testCustom() throws IOException {
        FeatureGenerator[] featureGenerators = new FeatureGenerator[]{new BagOfWordsFeatureGenerator(), new NGramFeatureGenerator(), new NGramFeatureGenerator(2, 3)};
        DoccatFactory factory = new DoccatFactory(featureGenerators);
        DoccatModel model = DoccatFactoryTest.train(factory);
        Assertions.assertNotNull((Object)model);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        DoccatModel fromSerialized = new DoccatModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals((int)3, (int)factory.getFeatureGenerators().length);
        Assertions.assertEquals(BagOfWordsFeatureGenerator.class, factory.getFeatureGenerators()[0].getClass());
        Assertions.assertEquals(NGramFeatureGenerator.class, factory.getFeatureGenerators()[1].getClass());
        Assertions.assertEquals(NGramFeatureGenerator.class, factory.getFeatureGenerators()[2].getClass());
    }
}

