/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.Collections;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BagOfWordsFeatureGeneratorTest {
    @Test
    void testNull() {
        BagOfWordsFeatureGenerator generator = new BagOfWordsFeatureGenerator();
        try {
            generator.extractFeatures(null, Collections.emptyMap());
            Assertions.fail((String)"NullPointerException must be thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    void testEmpty() {
        BagOfWordsFeatureGenerator generator = new BagOfWordsFeatureGenerator();
        Assertions.assertEquals((int)0, (int)generator.extractFeatures(new String[0], Collections.emptyMap()).size());
    }

    @Test
    void testUseAllTokens() {
        BagOfWordsFeatureGenerator generator = new BagOfWordsFeatureGenerator();
        Assertions.assertArrayEquals((Object[])new String[]{"bow=it", "bow=is", "bow=12.345", "bow=feet", "bow=long"}, (Object[])generator.extractFeatures(new String[]{"it", "is", "12.345", "feet", "long"}, Collections.emptyMap()).toArray());
    }

    @Test
    void testOnlyLetterTokens() {
        BagOfWordsFeatureGenerator generator = new BagOfWordsFeatureGenerator(true);
        Assertions.assertArrayEquals((Object[])new String[]{"bow=it", "bow=is", "bow=feet", "bow=long"}, (Object[])generator.extractFeatures(new String[]{"it", "is", "12.345", "feet", "long"}, Collections.emptyMap()).toArray());
    }
}

