/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.dictionary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DictionaryTest {
    private Dictionary getCaseSensitive() {
        return new Dictionary(true);
    }

    private Dictionary getCaseInsensitive() {
        return new Dictionary(false);
    }

    @Test
    void testLookup() {
        StringList entry1 = new StringList(new String[]{"1a", "1b"});
        StringList entry1u = new StringList(new String[]{"1A", "1B"});
        StringList entry2 = new StringList(new String[]{"1A", "1C"});
        Dictionary dict = this.getCaseInsensitive();
        dict.put(entry1);
        Assertions.assertTrue((boolean)dict.contains(entry1));
        Assertions.assertTrue((boolean)dict.contains(entry1u));
        Assertions.assertFalse((boolean)dict.contains(entry2));
    }

    @Test
    void testLookupCaseSensitive() {
        StringList entry1 = new StringList(new String[]{"1a", "1b"});
        StringList entry1u = new StringList(new String[]{"1A", "1B"});
        StringList entry2 = new StringList(new String[]{"1A", "1C"});
        Dictionary dict = this.getCaseSensitive();
        dict.put(entry1);
        Assertions.assertTrue((boolean)dict.contains(entry1));
        Assertions.assertFalse((boolean)dict.contains(entry1u));
        Assertions.assertFalse((boolean)dict.contains(entry2));
    }

    @Test
    void testSerialization() throws IOException {
        Dictionary reference = this.getCaseInsensitive();
        String a1 = "a1";
        String a2 = "a2";
        String a3 = "a3";
        String a5 = "a5";
        reference.put(new StringList(new String[]{a1, a2, a3, a5}));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        reference.serialize((OutputStream)out);
        Dictionary recreated = new Dictionary((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assertions.assertEquals((Object)reference, (Object)recreated);
    }

    @Test
    void testParseOneEntryPerLine() throws IOException {
        String testDictionary = "1a 1b 1c 1d \n 2a 2b 2c \n 3a \n 4a    4b   ";
        Dictionary dictionay = Dictionary.parseOneEntryPerLine((Reader)new StringReader(testDictionary));
        Assertions.assertEquals((int)4, (int)dictionay.size());
        Assertions.assertTrue((boolean)dictionay.contains(new StringList(new String[]{"1a", "1b", "1c", "1d"})));
        Assertions.assertTrue((boolean)dictionay.contains(new StringList(new String[]{"2a", "2b", "2c"})));
        Assertions.assertTrue((boolean)dictionay.contains(new StringList(new String[]{"3a"})));
        Assertions.assertTrue((boolean)dictionay.contains(new StringList(new String[]{"4a", "4b"})));
    }

    @Test
    void testEquals() {
        StringList entry1 = new StringList(new String[]{"1a", "1b"});
        StringList entry2 = new StringList(new String[]{"2a", "2b"});
        Dictionary dictA = this.getCaseInsensitive();
        dictA.put(entry1);
        dictA.put(entry2);
        Dictionary dictB = this.getCaseInsensitive();
        dictB.put(entry1);
        dictB.put(entry2);
        Dictionary dictC = this.getCaseSensitive();
        dictC.put(entry1);
        dictC.put(entry2);
        Assertions.assertEquals((Object)dictA, (Object)dictB);
        Assertions.assertEquals((Object)dictC, (Object)dictA);
        Assertions.assertEquals((Object)dictB, (Object)dictC);
    }

    @Test
    void testHashCode() {
        StringList entry1 = new StringList(new String[]{"1a", "1b"});
        StringList entry2 = new StringList(new String[]{"1A", "1B"});
        Dictionary dictA = this.getCaseInsensitive();
        dictA.put(entry1);
        Dictionary dictB = this.getCaseInsensitive();
        dictB.put(entry2);
        Dictionary dictC = this.getCaseSensitive();
        dictC.put(entry1);
        Dictionary dictD = this.getCaseSensitive();
        dictD.put(entry2);
        Assertions.assertEquals((int)dictA.hashCode(), (int)dictB.hashCode());
        Assertions.assertEquals((int)dictB.hashCode(), (int)dictC.hashCode());
        Assertions.assertEquals((int)dictC.hashCode(), (int)dictD.hashCode());
    }

    @Test
    void testToString() {
        StringList entry1 = new StringList(new String[]{"1a", "1b"});
        Dictionary dictA = this.getCaseInsensitive();
        dictA.toString();
        dictA.put(entry1);
        dictA.toString();
    }

    @Test
    void testDifferentCaseLookup() {
        StringList entry1 = new StringList(new String[]{"1a", "1b"});
        StringList entry2 = new StringList(new String[]{"1A", "1B"});
        Dictionary dict = this.getCaseInsensitive();
        dict.put(entry1);
        Assertions.assertTrue((boolean)dict.contains(entry2));
    }

    @Test
    void testDifferentCaseLookupCaseSensitive() {
        StringList entry1 = new StringList(new String[]{"1a", "1b"});
        StringList entry2 = new StringList(new String[]{"1A", "1B"});
        Dictionary dict = this.getCaseSensitive();
        dict.put(entry1);
        Assertions.assertFalse((boolean)dict.contains(entry2));
    }
}

