/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.dictionary;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DictionaryAsSetCaseSensitiveTest {
    private Dictionary getDict() {
        return new Dictionary(true);
    }

    private StringList asSL(String str) {
        return new StringList(str);
    }

    @Test
    void testLookup() {
        String a = "a";
        String b = "b";
        Dictionary dict = this.getDict();
        dict.put(this.asSL(a));
        Set set = dict.asStringSet();
        Assertions.assertTrue((boolean)set.contains(a));
        Assertions.assertFalse((boolean)set.contains(b));
        Assertions.assertFalse((boolean)set.contains(a.toUpperCase()));
    }

    @Test
    void testSet() {
        String a = "a";
        String a1 = "a";
        Dictionary dict = this.getDict();
        dict.put(this.asSL(a));
        dict.put(this.asSL(a1));
        Set set = dict.asStringSet();
        Assertions.assertTrue((boolean)set.contains(a));
        Assertions.assertEquals((int)1, (int)set.size());
    }

    @Test
    void testSetDiffCase() {
        String a = "a";
        String a1 = "A";
        Dictionary dict = this.getDict();
        dict.put(this.asSL(a));
        dict.put(this.asSL(a1));
        Set set = dict.asStringSet();
        Assertions.assertTrue((boolean)set.contains(a));
        Assertions.assertEquals((int)2, (int)set.size());
    }

    @Test
    void testEquals() {
        String entry1 = "1a";
        String entry2 = "1b";
        Dictionary dictA = this.getDict();
        dictA.put(this.asSL(entry1));
        dictA.put(this.asSL(entry2));
        Set setA = dictA.asStringSet();
        Dictionary dictB = this.getDict();
        dictB.put(this.asSL(entry1));
        dictB.put(this.asSL(entry2));
        Set setB = dictB.asStringSet();
        Assertions.assertEquals((int)setA.size(), (int)setB.size());
        Assertions.assertTrue((boolean)setA.containsAll(setB));
    }

    @Test
    void testEqualsDifferentCase() {
        Dictionary dictA = this.getDict();
        dictA.put(this.asSL("1a"));
        dictA.put(this.asSL("1b"));
        Set setA = dictA.asStringSet();
        Dictionary dictB = this.getDict();
        dictB.put(this.asSL("1A"));
        dictB.put(this.asSL("1B"));
        Set setB = dictB.asStringSet();
        Assertions.assertNotEquals((Object)setA, (Object)setB);
    }

    @Test
    void testHashCode() {
        String entry1 = "a1";
        Dictionary dictA = this.getDict();
        dictA.put(this.asSL(entry1));
        Set setA = dictA.asStringSet();
        Dictionary dictB = this.getDict();
        dictB.put(this.asSL(entry1));
        Set setB = dictB.asStringSet();
        Assertions.assertEquals((int)setA.hashCode(), (int)setB.hashCode());
    }

    @Test
    void testHashCodeDifferentCase() {
        String entry1 = "a1";
        Dictionary dictA = this.getDict();
        dictA.put(this.asSL(entry1));
        Set setA = dictA.asStringSet();
        Dictionary dictB = this.getDict();
        dictB.put(this.asSL(entry1.toUpperCase()));
        Set setB = dictB.asStringSet();
        Assertions.assertEquals((int)setA.hashCode(), (int)setB.hashCode());
    }

    @Test
    void testDifferentCaseLookup() {
        String entry1 = "1a";
        String entry2 = "1A";
        Dictionary dict = this.getDict();
        dict.put(this.asSL(entry1));
        Set set = dict.asStringSet();
        Assertions.assertFalse((boolean)set.contains(entry2));
    }

    @Test
    void testIterator() {
        String entry1 = "1a";
        String entry2 = "1b";
        Dictionary dictA = this.getDict();
        dictA.put(this.asSL(entry1));
        dictA.put(this.asSL(entry2));
        dictA.put(this.asSL(entry1.toUpperCase()));
        dictA.put(this.asSL(entry2.toUpperCase()));
        Iterator it = dictA.asStringSet().iterator();
        ArrayList<String> elements = new ArrayList<String>();
        while (it.hasNext()) {
            elements.add((String)it.next());
        }
        Assertions.assertEquals((int)4, (int)elements.size());
        Assertions.assertTrue((boolean)elements.contains(entry1));
        Assertions.assertTrue((boolean)elements.contains(entry2));
        Assertions.assertTrue((boolean)elements.contains(entry1.toUpperCase()));
        Assertions.assertTrue((boolean)elements.contains(entry2.toUpperCase()));
    }
}

