/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import nl.altindag.log.LogCaptor;
import opennlp.tools.AbstractTempDirTest;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.tokenizer.TokenizerTrainerTool;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.InvalidFormatException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class TokenizerTrainerToolTest
extends AbstractTempDirTest {
    private final String sampleSuccessData = "Pierre Vinken<SPLIT>, 61 years old<SPLIT>, will join the board as a nonexecutive director Nov. 29<SPLIT>.\nMr. Vinken is chairman of Elsevier N.V.<SPLIT>, the Dutch publishing group<SPLIT>.\nRudolph Agnew<SPLIT>, 55 years old and former chairman of Consolidated Gold Fields PLC<SPLIT>,\n    was named a nonexecutive director of this British industrial conglomerate<SPLIT>.\n";
    private final String sampleFailureData = "It is Fail Test Case.\n\nNothing in this sentence.";

    @BeforeAll
    public static void prepare() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("opennlp.tools.cmdline.CmdLineUtil");
        logger.setLevel(Level.INFO);
    }

    @AfterAll
    public static void cleanup() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("opennlp.tools.cmdline.CmdLineUtil");
        logger.setLevel(Level.OFF);
    }

    @Test
    public void testGetShortDescription() {
        TokenizerTrainerTool tokenizerTrainerTool = new TokenizerTrainerTool();
        Assertions.assertEquals((Object)"Trainer for the learnable tokenizer", (Object)tokenizerTrainerTool.getShortDescription());
    }

    @Test
    public void testLoadDictHappyCase() throws IOException {
        File dictFile = new File("lang/ga/abb_GA.xml");
        Dictionary dict = TokenizerTrainerTool.loadDict((File)dictFile);
        Assertions.assertNotNull((Object)dict);
    }

    @Test
    public void testLoadDictFailCase() {
        Assertions.assertThrows(InvalidFormatException.class, () -> TokenizerTrainerTool.loadDict((File)this.prepareDataFile("")));
    }

    @Test
    public void testTestRunHappyCase() throws IOException {
        try (LogCaptor logCaptor = LogCaptor.forClass(CmdLineUtil.class);){
            File model = this.tempDir.resolve("model-en.bin").toFile();
            String[] args = new String[]{"-model", model.getAbsolutePath(), "-alphaNumOpt", "false", "-lang", "en", "-data", String.valueOf(this.prepareDataFile("Pierre Vinken<SPLIT>, 61 years old<SPLIT>, will join the board as a nonexecutive director Nov. 29<SPLIT>.\nMr. Vinken is chairman of Elsevier N.V.<SPLIT>, the Dutch publishing group<SPLIT>.\nRudolph Agnew<SPLIT>, 55 years old and former chairman of Consolidated Gold Fields PLC<SPLIT>,\n    was named a nonexecutive director of this British industrial conglomerate<SPLIT>.\n")), "-encoding", "UTF-8"};
            ByteArrayInputStream stream = new ByteArrayInputStream("Pierre Vinken<SPLIT>, 61 years old<SPLIT>, will join the board as a nonexecutive director Nov. 29<SPLIT>.\nMr. Vinken is chairman of Elsevier N.V.<SPLIT>, the Dutch publishing group<SPLIT>.\nRudolph Agnew<SPLIT>, 55 years old and former chairman of Consolidated Gold Fields PLC<SPLIT>,\n    was named a nonexecutive director of this British industrial conglomerate<SPLIT>.\n".getBytes(StandardCharsets.UTF_8));
            System.setIn(stream);
            TokenizerTrainerTool trainerTool = new TokenizerTrainerTool();
            trainerTool.run("opennlp", args);
            Assertions.assertEquals((int)3, (int)logCaptor.getInfoLogs().size());
            String content = (String)logCaptor.getInfoLogs().get(2);
            Assertions.assertTrue((boolean)content.startsWith("Wrote tokenizer model to path:"));
            Assertions.assertTrue((boolean)model.delete());
        }
    }

    @Test
    public void testTestRunExceptionCase() throws IOException {
        File model = this.tempDir.resolve("model-en.bin").toFile();
        model.deleteOnExit();
        String[] args = new String[]{"-model", model.getAbsolutePath(), "-alphaNumOpt", "false", "-lang", "en", "-data", String.valueOf(this.prepareDataFile("It is Fail Test Case.\n\nNothing in this sentence.")), "-encoding", "UTF-8"};
        Assertions.assertThrows(TerminateToolException.class, () -> {
            TokenizerTrainerTool trainerTool = new TokenizerTrainerTool();
            trainerTool.run("opennlp", args);
        });
    }

    private File prepareDataFile(String input) throws IOException {
        Path dataFile = this.tempDir.resolve("data-en.train");
        Files.writeString(dataFile, (CharSequence)input, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        File f = dataFile.toFile();
        f.deleteOnExit();
        return f;
    }
}

