/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import opennlp.tools.AbstractModelLoaderTest;
import opennlp.tools.EnabledWhenCDNAvailable;
import opennlp.tools.cmdline.sentdetect.SentenceModelLoader;
import opennlp.tools.models.ModelType;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.DownloadUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
public class SentenceModelLoaderIT
extends AbstractModelLoaderTest {
    private SentenceModelLoader loader;

    @BeforeAll
    public static void initResources() {
        SUPPORTED_LANG_CODES.forEach(lang -> {
            try {
                DownloadUtil.downloadModel((String)lang, (ModelType)ModelType.SENTENCE_DETECTOR, SentenceModel.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @BeforeEach
    public void setup() {
        this.loader = new SentenceModelLoader();
    }

    @ParameterizedTest(name="Verify \"{0}\" sentence model loading")
    @ValueSource(strings={"en-ud-ewt", "fr-ud-gsd", "de-ud-gsd", "it-ud-vit", "nl-ud-alpino", "bg-ud-btb", "ca-ud-ancora", "cs-ud-pdtc", "da-ud-ddt", "el-ud-gdt", "es-ud-gsd", "et-ud-edt", "eu-ud-bdt", "fi-ud-tdt", "hr-ud-set", "hy-ud-bsut", "is-ud-icepahc", "ka-ud-glc", "kk-ud-ktb", "ko-ud-kaist", "lv-ud-lvtb", "no-ud-bokmaal", "pl-ud-pdb", "pt-ud-gsd", "ro-ud-rrt", "ru-ud-gsd", "sr-ud-set", "sk-ud-snk", "sl-ud-ssj", "sv-ud-talbanken", "tr-ud-boun", "uk-ud-iu"})
    public void testLoadModelByLanguage(String langModel) throws IOException {
        String modelName = "opennlp-" + langModel + "-sentence-1.3-2.5.4.bin";
        SentenceModel model = this.loader.loadModel(Files.newInputStream(OPENNLP_DIR.resolve(modelName), new OpenOption[0]));
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((boolean)model.isLoadedFromSerialized());
    }
}

