/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind.generator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import opennlp.tools.cmdline.namefind.generator.AbstractNewsGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomGermanNewsGenerator
extends AbstractNewsGenerator {
    private static final Logger logger = LoggerFactory.getLogger(RandomGermanNewsGenerator.class);
    private static final String START_DATE = "<START:date> ";
    private static final String END = " <END>";
    private static final String[] DATE_FORMATS = new String[]{"dd. MMMM yyyy", "EEEE, dd. MMMM yyyy", "MMMM yyyy", "dd.MM.yyyy", "d.MM.yyyy", "d.M.yyyy", "d.M.yy"};
    private static final String[] SPORTS_EVENTS = new String[]{"fand der legend\u00e4re Boxkampf zwischen Joe Louis und Max Schmeling statt.", "wurden die Olympischen Spiele in Rom ausgetragen.", "ereignete sich das 'Wunder von Bern', als die deutsche Fu\u00dfballnationalmannschaft die Weltmeisterschaft gewann.", "wurden die Olympischen Winterspiele in Lake Placid abgehalten.", "fand die Fu\u00dfball-Weltmeisterschaft in Italien statt.", "wurden die Olympischen Spiele in Atlanta ausgerichtet.", "wurde die Fu\u00dfball-Weltmeisterschaft in Brasilien ausgetragen.", "fanden die Olympischen Spiele in Tokio statt.", "wurde die Fu\u00dfball-Europameisterschaft in mehreren St\u00e4dten Europas ausgetragen.", "wurden die Olympischen Winterspiele in Peking abgehalten.", "wurde die Fu\u00dfball-Weltmeisterschaft in Katar ausgetragen.", "werden die Olympischen Spiele in Paris stattfinden.", "gewann die brasilianische Fu\u00dfballnationalmannschaft die Weltmeisterschaft.", "stellte Usain Bolt einen neuen Weltrekord im 100-Meter-Lauf auf.", "gewann Serena Williams ihren 23. Grand-Slam-Titel.", "fand das Finale der NBA-Meisterschaft statt, bei dem die Los Angeles Lakers den Titel holten.", "gewann Michael Phelps seine 23. olympische Goldmedaille.", "fand das Wimbledon-Finale statt, bei dem Roger Federer seinen achten Titel gewann.", "gewann die deutsche Fu\u00dfballnationalmannschaft die Europameisterschaft.", "fand das Super Bowl-Finale statt, bei dem die New England Patriots den Sieg errangen.", "gewann Rafael Nadal seinen 13. French-Open-Titel.", "fand das Finale der UEFA Champions League statt, bei dem Real Madrid den Titel holte."};
    private static final String[] MUSIC_EVENTS = new String[]{"erschien Elvis Presleys erste Single 'That's All Right'.", "wurde das Album 'A Night at the Opera' von Queen ver\u00f6ffentlicht.", "begann das Woodstock-Festival.", "erschien das Album 'Nevermind' von Nirvana.", "wurde das Album '25' von Adele ver\u00f6ffentlicht.", "verstarb Michael Jackson, der 'King of Pop'.", "erschien das Album 'A Seat at the Table' von Solange.", "wurde das Album 'Montero' von Lil Nas X ver\u00f6ffentlicht.", "erschien das Album 'Motomami' von Rosal\u00eda.", "wurde das Album 'Midnights' von Taylor Swift ver\u00f6ffentlicht.", "wurde das Album 'Thriller' von Michael Jackson ver\u00f6ffentlicht.", "erschien das Album 'The Dark Side of the Moon' von Pink Floyd.", "wurde das Album 'Abbey Road' von den Beatles ver\u00f6ffentlicht.", "erschien das Album 'Back in Black' von AC/DC.", "wurde das Album 'Rumours' von Fleetwood Mac ver\u00f6ffentlicht.", "erschien das Album 'Hotel California' von den Eagles.", "wurde das Album 'Born to Run' von Bruce Springsteen ver\u00f6ffentlicht.", "erschien das Album 'Purple Rain' von Prince.", "wurde das Album 'The Wall' von Pink Floyd ver\u00f6ffentlicht.", "erschien das Album 'Led Zeppelin IV' von Led Zeppelin."};
    private static final String[] CINEMA_EVENTS = new String[]{"kam der Film 'Vom Winde verweht' in die Kinos.", "wurde der Film 'Lawrence von Arabien' ver\u00f6ffentlicht.", "kam der Film 'Star Wars: Eine neue Hoffnung' in die Kinos.", "erschien der Film 'Titanic'.", "kam der Film 'Avatar' in die Kinos.", "wurde der Film 'Die Eisk\u00f6nigin \u2013 V\u00f6llig unverfroren' ver\u00f6ffentlicht.", "kam der Film 'Thor: Tag der Entscheidung' in die Kinos.", "wurde der Film 'Der Pate' ver\u00f6ffentlicht.", "erschien der Film 'Schindlers Liste'.", "kam der Film 'Der Herr der Ringe: Die Gef\u00e4hrten' in die Kinos.", "wurde der Film 'Forrest Gump' ver\u00f6ffentlicht.", "erschien der Film 'Der K\u00f6nig der L\u00f6wen'.", "kam der Film 'Jurassic Park' in die Kinos.", "wurde der Film 'Inception' ver\u00f6ffentlicht.", "erschien der Film 'The Matrix'.", "kam der Film 'Gladiator' in die Kinos.", "wurde der Film 'Pulp Fiction' ver\u00f6ffentlicht."};
    private static final String[] ECONOMY_EVENTS = new String[]{"wurde bekannt gegeben, dass die globale Wirtschaft ein Wachstum von 3,5 % verzeichnet hat.", "wurde ein bedeutendes Abkommen zur F\u00f6rderung der internationalen Zusammenarbeit im Bereich der Wirtschaft unterzeichnet.", "fand eine gro\u00dfe Konferenz zur globalen Wirtschaftsversorgung statt, bei der f\u00fchrende Experten \u00fcber Strategien zur Verbesserung der Wirtschaftsdienste diskutierten.", "wurde die Einf\u00fchrung des Euro als gemeinsame W\u00e4hrung in Europa beschlossen.", "fand die Gr\u00fcndung der Weltbank statt.", "wurde die Europ\u00e4ische Zentralbank gegr\u00fcndet.", "wurde das Bretton-Woods-Abkommen unterzeichnet.", "fand die erste Sitzung des Weltwirtschaftsforums in Davos statt.", "wurde die Welthandelsorganisation (WTO) gegr\u00fcndet.", "wurde der Vertrag von Maastricht unterzeichnet, der zur Gr\u00fcndung der Europ\u00e4ischen Union f\u00fchrte.", "wurde die Einf\u00fchrung des Marshallplans zur wirtschaftlichen Wiederaufbauhilfe nach dem Zweiten Weltkrieg beschlossen.", "wurde die Gr\u00fcndung der Organisation f\u00fcr wirtschaftliche Zusammenarbeit und Entwicklung (OECD) beschlossen.", "fand die erste Sitzung der G20 statt."};
    private static final String[] POLITICS_EVENTS = new String[]{"fanden die Bundestagswahlen in Deutschland statt.", "wurde ein neues Gesetz zur F\u00f6rderung der digitalen Bildung verabschiedet.", "wurde ein bedeutendes Abkommen zur F\u00f6rderung der internationalen Zusammenarbeit im Bereich der Politik unterzeichnet.", "wurde die Allgemeine Erkl\u00e4rung der Menschenrechte von den Vereinten Nationen verabschiedet.", "fand die Gr\u00fcndung der Vereinten Nationen statt.", "wurde der Vertrag von Versailles unterzeichnet, der den Ersten Weltkrieg beendete.", "wurde die NATO gegr\u00fcndet.", "fand die erste Sitzung des Europ\u00e4ischen Parlaments statt.", "wurde der Vertrag von Lissabon unterzeichnet, der die Europ\u00e4ische Union reformierte.", "wurde die Berliner Mauer errichtet.", "fand die Wiedervereinigung Deutschlands statt.", "wurde der Vertrag von Rom unterzeichnet, der zur Gr\u00fcndung der Europ\u00e4ischen Wirtschaftsgemeinschaft f\u00fchrte.", "wurde die Charta der Vereinten Nationen unterzeichnet."};
    private static final String[] SCIENCE_EVENTS = new String[]{"wurde ein bedeutender Durchbruch in der Quantencomputing-Forschung erzielt.", "startete ein bedeutendes wissenschaftliches Projekt zur Erforschung des Klimawandels.", "fand ein bedeutendes wissenschaftliches Symposium zu den neuesten Entwicklungen in der Genforschung statt.", "wurde die Struktur der DNA von James Watson und Francis Crick entdeckt.", "landete die Apollo-11-Mission erfolgreich auf dem Mond.", "wurde das erste k\u00fcnstliche Herz erfolgreich transplantiert.", "wurde das Human Genome Project abgeschlossen.", "wurde das erste Klonschaf, Dolly, geboren.", "wurde der Large Hadron Collider in Betrieb genommen.", "wurde der erste Impfstoff gegen COVID-19 zugelassen.", "wurde das erste Bild eines Schwarzen Lochs ver\u00f6ffentlicht.", "wurde die erste erfolgreiche Gentherapie bei einem Menschen durchgef\u00fchrt.", "wurde die erste Raumsonde auf dem Mars gelandet.", "wurde die Existenz von Gravitationswellen nachgewiesen.", "wurde das erste k\u00fcnstliche Organ erfolgreich transplantiert.", "wurde die erste CRISPR-Geneditierung bei einem Menschen durchgef\u00fchrt.", "wurde das erste vollst\u00e4ndig elektrische Flugzeug getestet.", "wurde die erste Quantenkommunikation \u00fcber Satellit durchgef\u00fchrt.", "wurde die erste erfolgreiche Stammzelltherapie bei einem Menschen durchgef\u00fchrt.", "wurde das erste Bild eines Exoplaneten ver\u00f6ffentlicht."};
    private static final String[] SENTENCE_STARTS_WITH_DATE = new String[]{"Am", "Im", "An einem", "W\u00e4hrend des", "Zu Beginn des", "Gegen Ende des", "In der Mitte des", "Kurz nach dem", "Ungef\u00e4hr um den", "Im Verlauf des", "Nach dem", "Vor dem", "Etwa am"};
    private static final String[] SENTENCE_STARTS_WITHOUT_DATE = new String[]{"Berichten zufolge", "Laut einer Ank\u00fcndigung", "Nach den letzten Meldungen", "Laut einer Mitteilung", "Laut Berichten", "Wie dpa berichtet,", "Nach Angaben des Beh\u00f6rden", "Nach Angaben von Experten"};
    private static final int NUM_SENTENCES = 10000;

    @Override
    String[] getSupportedDateFormats() {
        return DATE_FORMATS;
    }

    public static void main(String[] args) {
        String outputFileName = args.length != 1 ? "RandomNewsWithGeneratedDates_DE.train" : args[0];
        RandomGermanNewsGenerator newsGen = new RandomGermanNewsGenerator();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileName));){
            for (int i = 0; i < 10000; ++i) {
                writer.write(newsGen.generateSentence());
                writer.newLine();
            }
            logger.info("Text corpus with '{}' sentences generated and written to: '{}'", (Object)10000, (Object)outputFileName);
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String generateSentence() {
        String sentence;
        String eventType;
        String[] eventTypes = new String[]{"sports", "music", "cinema", "economy", "politics", "science"};
        String event = switch (eventType = eventTypes[new Random().nextInt(eventTypes.length)]) {
            case "sports" -> SPORTS_EVENTS[new Random().nextInt(SPORTS_EVENTS.length)];
            case "music" -> MUSIC_EVENTS[new Random().nextInt(MUSIC_EVENTS.length)];
            case "cinema" -> CINEMA_EVENTS[new Random().nextInt(CINEMA_EVENTS.length)];
            case "economy" -> ECONOMY_EVENTS[new Random().nextInt(ECONOMY_EVENTS.length)];
            case "politics" -> POLITICS_EVENTS[new Random().nextInt(POLITICS_EVENTS.length)];
            case "science" -> SCIENCE_EVENTS[new Random().nextInt(SCIENCE_EVENTS.length)];
            default -> "";
        };
        Random random = new Random();
        if (random.nextDouble() < 0.15) {
            String date = START_DATE + this.formatDateWithTags(this.generateRandomDate(this.cal), Locale.GERMAN) + END;
            String sentenceStart = SENTENCE_STARTS_WITH_DATE[new Random().nextInt(SENTENCE_STARTS_WITH_DATE.length)];
            sentence = String.format("%s %s %s", sentenceStart, date, event);
        } else {
            String sentenceStart = SENTENCE_STARTS_WITHOUT_DATE[new Random().nextInt(SENTENCE_STARTS_WITHOUT_DATE.length)];
            sentence = String.format("%s %s", sentenceStart, event);
        }
        return sentence;
    }
}

