/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind.generator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import opennlp.tools.cmdline.namefind.generator.AbstractNewsGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomEnglishNewsGenerator
extends AbstractNewsGenerator {
    private static final Logger logger = LoggerFactory.getLogger(RandomEnglishNewsGenerator.class);
    private static final String START_DATE = "<START:date> ";
    private static final String END = " <END>";
    private static final String[] DATE_FORMATS = new String[]{"d MMMM yyyy", "dd/mm/yyyy", "m/d/yy", "m/d/yyyy", "yyyy-mm-dd", "MMMM d, yyyy", "EEEE, dd/mm/yyyy", "EEEE, yyyy-mm-dd", "MMMM yyyy"};
    private static final String[] SPORTS_EVENTS = new String[]{"the legendary boxing match between Joe Louis and Max Schmeling took place.", "the Olympic Games were held in Rome.", "the \u2018Miracle of Bern\u2019 occurred, when the German national football team won the World Cup.", "the Winter Olympics were held in Lake Placid.", "the Football World Cup took place in Italy.", "the Olympic Games were held in Atlanta.", "the FIFA World Cup was held in Brazil", "the Olympic Games took place in Tokyo", "the European Football Championship was held in several European cities.", "the Winter Olympics were held in Beijing.", "the FIFA World Cup was held in Qatar.", "the Olympic Games will take place in Paris.", "the Brazilian national football team won the World Cup.", "Usain Bolt set a new world record in the 100-meter sprint.", "Serena Williams won her 23rd Grand Slam title.", "the NBA championship final took place, with the Los Angeles Lakers taking the title.", "Michael Phelps won his 23rd Olympic gold medal.", "the Wimbledon final took place, with Roger Federer winning his eighth title.", "the German national football team won the European Championship.", "the Super Bowl final took place, with the New England Patriots emerging victorious.", "Rafael Nadal won his 13th French Open title.", "the UEFA Champions League final took place, with Real Madrid lifting the title."};
    private static final String[] MUSIC_EVENTS = new String[]{"Elvis Presley's first single \u2018That's All Right\u2019 was released.", "the album \u2018A Night at the Opera\u2019 by Queen was released.", "the Woodstock Festival began.", "the album \u2018Nevermind\u2019 by Nirvana was released.", "the album \u201825\u2019 by Adele was released.", "Michael Jackson, the \u2018King of Pop\u2019, died.", "the album \u2018A Seat at the Table\u2019 by Solange was released.", "the album \u2018Montero\u2019 by Lil Nas X was released.", "the album \u2018Motomami\u2019 by Rosal\u00eda was released.", "the album \u2018Midnights\u2019 by Taylor Swift was released.", "the album \u2018Thriller\u2019 by Michael Jackson was released.", "Pink Floyd's \u2018The Dark Side of the Moon\u2019 was released.", "The Beatles\u2018 \u2019Abbey Road\u2018 was released.", "AC/DC's \u2019Back in Black\u2018 was released.", "Fleetwood Mac's \u2019Rumours\u2018 was released.", "The Eagles\u2019 \u2018Hotel California\u2019 was released.", "Bruce Springsteen's album \u2018Born to Run\u2019 was released.", "Prince's album \u2018Purple Rain\u2019.", "Pink Floyd's album \u2018The Wall\u2019.", "Led Zeppelin's album \u2018Led Zeppelin IV\u2019."};
    private static final String[] CINEMA_EVENTS = new String[]{"the film \u2018Gone with the Wind\u2019 was released in cinemas.", "the film \u2018Lawrence of Arabia\u2019 was released.", "the film \u2018Star Wars: A New Hope\u2019 was released in cinemas.", "the film \u2018Titanic\u2019 was released.", "the film \u2018Avatar\u2019 was released in cinemas.", "the film \u2018Frozen\u2019 was released.", "the film \u2018Thor: Ragnarok\u2019 was released in cinemas.", "the film \u2018The Godfather\u2019 was released.", "the film \u2018Schindler's List\u2019 was released.", "the film \u2018The Lord of the Rings: The Fellowship of the Ring\u2019 was released in cinemas.", "the film \u2018Forrest Gump\u2019 was released.", "the film \u2018The Lion King\u2019 was released.", "the film \u2018Jurassic Park\u2019 was released in cinemas.", "the film \u2018Inception\u2019 was released.", "the film \u2018The Matrix\u2019 was released.", "the film \u2018Gladiator\u2019 was released in cinemas.", "the film \u2018Pulp Fiction\u2019 was released."};
    private static final String[] ECONOMY_EVENTS = new String[]{"it was announced that the global economy had grown by 3.5%.", "an important agreement was signed to promote international cooperation in the field of economics.", "a major conference on global economic services took place, at which leading experts discussed strategies for improving economic services.", "the introduction of the euro as a common currency in Europe was decided.", "the World Bank was established.", "the European Central Bank was established.", "the Bretton Woods Agreement was signed.", "the first meeting of the World Economic Forum was held in Davos.", "the World Trade Organization (WTO) was established.", "the Maastricht Treaty was signed, leading to the establishment of the European Union.", "the introduction of the Marshall Plan for economic reconstruction aid after the World War II.", "the decision was taken to establish the Organization for Economic Cooperation and Development (OECD).", "the first G20 summit took place."};
    private static final String[] POLITICS_EVENTS = new String[]{"parliamentary elections took place in Germany.", "a new law was passed to promote digital education.", "an important agreement was signed to promote international cooperation in the field of politics.", "the Universal Declaration of Human Rights was adopted by the United Nations.", "the founding of the United Nations took place.", "the Treaty of Versailles was signed, ending the First World War.", "NATO was founded.", "the first session of the European Parliament took place", "the Lisbon Treaty was signed, reforming the European Union", "the Berlin Wall was built", "the reunification of Germany took place", "the Treaty of Rome was signed, leading to the establishment of the European Economic Community", "the United Nations Charter was signed."};
    private static final String[] SCIENCE_EVENTS = new String[]{"a significant breakthrough in quantum computing research was made", "a major scientific project to study climate change was launched", "a major scientific symposium was held on the latest developments in genetic research", "the structure of DNA was discovered by James Watson and Francis Crick", "the Apollo 11 mission successfully landed on the moon", "the first artificial heart was successfully transplanted", "the Human Genome Project was completed", "the first cloned sheep, Dolly, was born", "the Large Hadron Collider was launched", "the first vaccine against COVID-19 was approved", "the first image of a black hole was published", "the first successful gene therapy was performed in a human", "the first space probe landed on Mars", "the existence of gravitational waves was detected", "the first artificial organ was successfully transplanted", "the first CRISPR gene editing was performed in a human", "the first all-electric aircraft was tested", "the first quantum communication via satellite was carried out", "the first successful stem cell therapy was performed in a human", "the first image of an exoplanet was published."};
    private static final String[] SENTENCE_STARTS_WITH_DATE = new String[]{"On", "In", "On the", "During the", "At the start of", "Towards the end of", "In the middle of", "Shortly after", "Around", "During", "After", "Before", "Around"};
    private static final String[] SENTENCE_STARTS_WITHOUT_DATE = new String[]{"As reported,", "According to an announcement,", "According to the latest reports,", "According to a statement,", "As reported by Reuters,", "According to the authorities,", "According to experts,"};
    private static final int NUM_SENTENCES = 10000;

    @Override
    String[] getSupportedDateFormats() {
        return DATE_FORMATS;
    }

    public static void main(String[] args) {
        String outputFileName = args.length != 1 ? "RandomNewsWithGeneratedDates_EN.train" : args[0];
        RandomEnglishNewsGenerator newsGen = new RandomEnglishNewsGenerator();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileName));){
            for (int i = 0; i < 10000; ++i) {
                writer.write(newsGen.generateSentence());
                writer.newLine();
            }
            logger.info("Text corpus with '{}' sentences generated and written to: '{}'", (Object)10000, (Object)outputFileName);
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String generateSentence() {
        String sentence;
        String eventType;
        String[] eventTypes = new String[]{"sports", "music", "cinema", "economy", "politics", "science"};
        String event = switch (eventType = eventTypes[new Random().nextInt(eventTypes.length)]) {
            case "sports" -> SPORTS_EVENTS[new Random().nextInt(SPORTS_EVENTS.length)];
            case "music" -> MUSIC_EVENTS[new Random().nextInt(MUSIC_EVENTS.length)];
            case "cinema" -> CINEMA_EVENTS[new Random().nextInt(CINEMA_EVENTS.length)];
            case "economy" -> ECONOMY_EVENTS[new Random().nextInt(ECONOMY_EVENTS.length)];
            case "politics" -> POLITICS_EVENTS[new Random().nextInt(POLITICS_EVENTS.length)];
            case "science" -> SCIENCE_EVENTS[new Random().nextInt(SCIENCE_EVENTS.length)];
            default -> "";
        };
        Random random = new Random();
        if (random.nextDouble() < 0.15) {
            String date = START_DATE + this.formatDateWithTags(this.generateRandomDate(this.cal), Locale.ENGLISH) + END;
            String sentenceStart = SENTENCE_STARTS_WITH_DATE[new Random().nextInt(SENTENCE_STARTS_WITH_DATE.length)];
            sentence = String.format("%s %s %s", sentenceStart, date, event);
        } else {
            String sentenceStart = SENTENCE_STARTS_WITHOUT_DATE[new Random().nextInt(SENTENCE_STARTS_WITHOUT_DATE.length)];
            sentence = String.format("%s %s", sentenceStart, event);
        }
        return sentence;
    }
}

