/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind.generator;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

abstract class AbstractNewsGenerator {
    protected Calendar cal = new GregorianCalendar();

    AbstractNewsGenerator() {
    }

    abstract String[] getSupportedDateFormats();

    Date generateRandomDate(Calendar cal) {
        cal.set(1900, 0, 1);
        long startMillis = cal.getTimeInMillis();
        long endMillis = new Date().getTime();
        long randomMillisSinceEpoch = ThreadLocalRandom.current().nextLong(startMillis, endMillis);
        return new Date(randomMillisSinceEpoch);
    }

    String formatDateWithTags(Date date, Locale loc) {
        String[] formats = this.getSupportedDateFormats();
        SimpleDateFormat dateFormat = new SimpleDateFormat(formats[new Random().nextInt(formats.length)], loc);
        return dateFormat.format(date);
    }
}

