/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import opennlp.tools.AbstractModelLoaderTest;
import opennlp.tools.EnabledWhenCDNAvailable;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.namefind.TokenNameFinderModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@EnabledWhenCDNAvailable(hostname="opennlp.sourceforge.net")
public class TokenNameFinderModelLoaderTest
extends AbstractModelLoaderTest {
    private TokenNameFinderModelLoader loader;

    @BeforeAll
    public static void initResources() {
        List<String> resources = List.of("en");
        resources.forEach(lang -> {
            try {
                TokenNameFinderModelLoaderTest.downloadVersion15Model("en-ner-location.bin");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @BeforeEach
    public void setup() {
        this.loader = new TokenNameFinderModelLoader();
    }

    @ParameterizedTest(name="Verify \"{0}\" NER model loading")
    @ValueSource(strings={"en-ner-location.bin"})
    public void testLoadModelViaResource(String modelName) throws IOException {
        TokenNameFinderModel model = this.loader.loadModel(Files.newInputStream(OPENNLP_DIR.resolve(modelName), new OpenOption[0]));
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((boolean)model.isLoadedFromSerialized());
    }
}

