/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.languagemodel;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import nl.altindag.log.LogCaptor;
import opennlp.tools.AbstractLoggerTest;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.languagemodel.NGramLanguageModelTool;
import opennlp.tools.ngram.NGramGenerator;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class NGramLanguageModelToolTest
extends AbstractLoggerTest {
    private static final int NGRAM_MIN_LENGTH = 1;
    private static final int NGRAM_MAX_LENGTH = 3;
    @TempDir
    private static File testDir;
    private static final InputStream sysInputStream;

    NGramLanguageModelToolTest() {
    }

    @BeforeAll
    public static void prepare() {
        NGramLanguageModelToolTest.prepare("opennlp");
    }

    @ParameterizedTest
    @MethodSource(value={"provideNgramDictionaryXML"})
    void testRunTool(String dataFileName, String[][] providedAndPredictedTokens) {
        try (LogCaptor logCaptorNglmTool = LogCaptor.forClass(NGramLanguageModelTool.class);
             LogCaptor logCaptorPerfMon = LogCaptor.forClass(PerformanceMonitor.class);){
            File inputData = new File(testDir, String.format(dataFileName, new Object[0]));
            StringBuilder userInput = new StringBuilder();
            for (String[] item : providedAndPredictedTokens) {
                userInput.append(item[0]).append("\n");
            }
            System.setIn(new ByteArrayInputStream(userInput.toString().getBytes()));
            NGramLanguageModelTool nGramLMTool = new NGramLanguageModelTool();
            nGramLMTool.run(new String[]{inputData.getPath()});
            LinkedList actual = new LinkedList();
            actual.addAll(logCaptorNglmTool.getInfoLogs());
            actual.addAll(logCaptorPerfMon.getInfoLogs());
            LinkedList<Executable> assertions = new LinkedList<Executable>();
            for (String[] item : providedAndPredictedTokens) {
                assertions.add(() -> Assertions.assertTrue((boolean)actual.stream().filter(l -> l.contains(String.join((CharSequence)", ", item[0].split(" ")))).findFirst().orElseThrow(AssertionError::new).contains(item[1])));
            }
            assertions.add(() -> Assertions.assertEquals((Object)("Total: " + providedAndPredictedTokens.length + " nglm"), (Object)actual.stream().filter(l -> l.contains("Total")).findFirst().orElseThrow(AssertionError::new)));
            Assertions.assertAll(assertions);
        }
    }

    private static Stream<Arguments> provideNgramDictionaryXML() {
        LinkedList<Arguments> arguments = new LinkedList<Arguments>();
        List<Map<String, String[][]>> testFileNamesWithProvidedAndPredictedTokens = List.of(Map.of("sentences_set_1", new String[][]{{"data availability is by", "now"}, {"machine and deep learning", "algorithms"}}), Map.of("sentences_set_2", new String[][]{{"lunar landing mission was the", "first"}}));
        for (Map<String, String[][]> testInput : testFileNamesWithProvidedAndPredictedTokens) {
            NGramModel ngModel = new NGramModel();
            for (Map.Entry<String, String[][]> entry : testInput.entrySet()) {
                try {
                    InputStream is = ngModel.getClass().getResourceAsStream(String.format("/opennlp/tools/cmdline/languagemodel/%s.txt", entry.getKey()));
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                         FileOutputStream fos = new FileOutputStream(new File(testDir, String.format("%s_ngram_dict.xml", entry.getKey())));){
                        reader.lines().map(l -> NGramGenerator.generate(Arrays.asList(l.split(" ")), (int)3, (String)" ")).flatMap(Collection::stream).forEach(t -> ngModel.add(new StringList(t.split(" ")), 1, 3));
                        ngModel.serialize((OutputStream)fos);
                        arguments.add(Arguments.of((Object[])new Object[]{String.format("%s_ngram_dict.xml", entry.getKey()), entry.getValue()}));
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new TerminateToolException(-1, "IO Error while creating test data files " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return arguments.stream();
    }

    @AfterAll
    public static void afterAll() {
        NGramLanguageModelToolTest.restore("opennlp");
        System.setIn(sysInputStream);
    }

    static {
        sysInputStream = System.in;
    }
}

