/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.langdetect;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import opennlp.tools.AbstractModelLoaderTest;
import opennlp.tools.EnabledWhenCDNAvailable;
import opennlp.tools.cmdline.langdetect.LanguageDetectorModelLoader;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
public class LanguageDetectorModelLoaderTest
extends AbstractModelLoaderTest {
    private LanguageDetectorModelLoader loader;

    @BeforeAll
    public static void initResources() {
        List<String> resources = List.of("en");
        resources.forEach(lang -> {
            try {
                LanguageDetectorModelLoaderTest.downloadVersion183Model("langdetect-183.bin");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @BeforeEach
    public void setup() {
        this.loader = new LanguageDetectorModelLoader();
    }

    @ParameterizedTest(name="Verify \"{0}\" language detector model loading")
    @ValueSource(strings={"langdetect-183.bin"})
    public void testLoadModelViaResource(String modelName) throws IOException {
        LanguageDetectorModel model = this.loader.loadModel(Files.newInputStream(OPENNLP_DIR.resolve(modelName), new OpenOption[0]));
        Assertions.assertNotNull((Object)model);
        Assertions.assertTrue((boolean)model.isLoadedFromSerialized());
    }
}

