/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import nl.altindag.log.LogCaptor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TokenNameFinderTool;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class TokenNameFinderToolTest {
    @BeforeAll
    public static void prepare() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("opennlp.tools.cmdline.namefind");
        logger.setLevel(Level.INFO);
    }

    @AfterAll
    public static void cleanup() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("opennlp.tools.cmdline.namefind");
        logger.setLevel(Level.OFF);
    }

    @Test
    void run() throws IOException {
        try (LogCaptor logCaptor = LogCaptor.forClass(TokenNameFinderTool.class);){
            File model1 = this.trainModel();
            String[] args = new String[]{model1.getAbsolutePath()};
            String in = "It is Stefanie Schmidt.\n";
            ByteArrayInputStream stream = new ByteArrayInputStream("It is Stefanie Schmidt.\n".getBytes(StandardCharsets.UTF_8));
            System.setIn(stream);
            TokenNameFinderTool tool = new TokenNameFinderTool();
            tool.run(args);
            Assertions.assertEquals((int)1, (int)logCaptor.getInfoLogs().size());
            String content = (String)logCaptor.getInfoLogs().get(0);
            logCaptor.clearLogs();
            Assertions.assertEquals((Object)"It is <START:person> Stefanie Schmidt. <END>", (Object)content);
            Assertions.assertTrue((boolean)model1.delete());
        }
    }

    @Test
    void invalidModel() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            String[] args = new String[]{"invalidmodel.bin"};
            TokenNameFinderTool tool = new TokenNameFinderTool();
            tool.run(args);
        });
    }

    @Test
    void usage() {
        try (LogCaptor logCaptor = LogCaptor.forClass(TokenNameFinderTool.class);){
            String[] args = new String[]{};
            TokenNameFinderTool tool = new TokenNameFinderTool();
            tool.run(args);
            Assertions.assertEquals((int)1, (int)logCaptor.getInfoLogs().size());
            String content = (String)logCaptor.getInfoLogs().get(0);
            Assertions.assertEquals((Object)tool.getHelp(), (Object)content.trim());
        }
    }

    private File trainModel() throws IOException {
        TokenNameFinderModel model;
        PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/namefind/AnnotatedSentencesWithTypes.txt")), StandardCharsets.ISO_8859_1);
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 70);
        params.put("Cutoff", 1);
        TokenNameFinderFactory nameFinderFactory = new TokenNameFinderFactory();
        try (NameSampleDataStream sampleStream = new NameSampleDataStream((ObjectStream)lineStream);){
            model = NameFinderME.train((String)"eng", null, (ObjectStream)sampleStream, (TrainingParameters)params, (TokenNameFinderFactory)nameFinderFactory);
        }
        File modelFile = Files.createTempFile("model", ".bin", new FileAttribute[0]).toFile();
        try (BufferedOutputStream modelOut = new BufferedOutputStream(new FileOutputStream(modelFile));){
            model.serialize((OutputStream)modelOut);
        }
        return modelFile;
    }
}

