/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.params.EncodingParameter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArgumentParserTest {
    @Test
    void testZeroMethods() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArgumentParser.createUsage(ZeroMethods.class));
    }

    @Test
    void testInvalidMethodName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArgumentParser.createUsage(InvalidMethodName.class));
    }

    @Test
    void testInvalidReturnType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArgumentParser.createUsage(InvalidReturnType.class));
    }

    @Test
    void testSimpleArguments() {
        String argsString = "-encoding UTF-8 -alphaNumOpt false";
        SimpleArguments args = (SimpleArguments)ArgumentParser.parse((String[])argsString.split(" "), SimpleArguments.class);
        Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)args.getEncoding());
        Assertions.assertEquals((Integer)100, (Integer)args.getIterations());
        Assertions.assertNull((Object)args.getCutoff());
        Assertions.assertEquals((Object)false, (Object)args.getAlphaNumOpt());
    }

    @Test
    void testSimpleArgumentsMissingEncoding() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String argsString = "-alphaNumOpt false";
            Assertions.assertFalse((boolean)ArgumentParser.validateArguments((String[])argsString.split(" "), SimpleArguments.class));
            ArgumentParser.parse((String[])argsString.split(" "), SimpleArguments.class);
        });
    }

    @Test
    void testAllOptionalArgumentsOneArgument() {
        String argsString = "-alphaNumOpt false";
        Assertions.assertTrue((boolean)ArgumentParser.validateArguments((String[])argsString.split(" "), AllOptionalArguments.class));
        ArgumentParser.parse((String[])argsString.split(" "), AllOptionalArguments.class);
    }

    @Test
    void testAllOptionalArgumentsZeroArguments() {
        String[] args = new String[]{};
        Assertions.assertTrue((boolean)ArgumentParser.validateArguments((String[])args, AllOptionalArguments.class));
        ArgumentParser.parse((String[])args, AllOptionalArguments.class);
    }

    @Test
    void testAllOptionalArgumentsExtraArgument() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String argsString = "-encoding UTF-8";
            Assertions.assertFalse((boolean)ArgumentParser.validateArguments((String[])argsString.split(" "), AllOptionalArguments.class));
            ArgumentParser.parse((String[])argsString.split(" "), AllOptionalArguments.class);
        });
    }

    @Test
    void testSimpleArgumentsUsage() {
        String[] arguments = new String[]{"-encoding charset", "[-iterations num]", "[-alphaNumOpt true|false]"};
        String usage = ArgumentParser.createUsage(SimpleArguments.class);
        int expectedLength = 2;
        for (String arg : arguments) {
            Assertions.assertTrue((boolean)usage.contains(arg));
            expectedLength += arg.length();
        }
        Assertions.assertTrue((boolean)usage.contains("a charset encoding"));
        Assertions.assertTrue((expectedLength < usage.length() ? 1 : 0) != 0);
    }

    @Test
    void testDefaultEncodingParameter() {
        String[] args = "-something aValue".split(" ");
        Assertions.assertTrue((boolean)ArgumentParser.validateArguments((String[])args, ExtendsEncodingParameter.class));
        ExtendsEncodingParameter params = (ExtendsEncodingParameter)ArgumentParser.parse((String[])args, ExtendsEncodingParameter.class);
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)params.getEncoding());
    }

    @Test
    void testSetEncodingParameter() {
        Collection<Charset> availableCharset = Charset.availableCharsets().values();
        String notTheDefaultCharset = StandardCharsets.UTF_8.name();
        for (Charset charset : availableCharset) {
            if (charset.equals(Charset.defaultCharset())) continue;
            notTheDefaultCharset = charset.name();
            break;
        }
        String[] args = ("-something aValue -encoding " + notTheDefaultCharset).split(" ");
        Assertions.assertTrue((boolean)ArgumentParser.validateArguments((String[])args, ExtendsEncodingParameter.class));
        ExtendsEncodingParameter params = (ExtendsEncodingParameter)ArgumentParser.parse((String[])args, ExtendsEncodingParameter.class);
        Assertions.assertEquals((Object)Charset.forName(notTheDefaultCharset), (Object)params.getEncoding());
    }

    static interface SimpleArguments
    extends AllOptionalArguments {
        @ArgumentParser.ParameterDescription(valueName="charset", description="a charset encoding")
        public String getEncoding();

        @ArgumentParser.OptionalParameter
        public Integer getCutoff();
    }

    static interface AllOptionalArguments {
        @ArgumentParser.ParameterDescription(valueName="num")
        @ArgumentParser.OptionalParameter(defaultValue="100")
        public Integer getIterations();

        @ArgumentParser.ParameterDescription(valueName="true|false")
        @ArgumentParser.OptionalParameter(defaultValue="true")
        public Boolean getAlphaNumOpt();
    }

    static interface ExtendsEncodingParameter
    extends EncodingParameter {
        @ArgumentParser.ParameterDescription(valueName="value")
        public String getSomething();
    }

    static interface InvalidReturnType {
        public Exception getTest();
    }

    static interface InvalidMethodName {
        public String invalidMethodName();
    }

    static interface ZeroMethods {
    }
}

