/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyChunkSampleStream
extends FilterObjectStream<String, ChunkSample> {
    private static final Logger logger = LoggerFactory.getLogger(DummyChunkSampleStream.class);
    private final boolean mIsPredicted;
    private int count = 0;

    public DummyChunkSampleStream(ObjectStream<String> samples, boolean isPredicted) {
        super(samples);
        this.mIsPredicted = isPredicted;
    }

    public ChunkSample read() throws IOException {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> posTags = new ArrayList<String>();
        ArrayList<String> chunkTags = new ArrayList<String>();
        ArrayList<String> predictedChunkTags = new ArrayList<String>();
        String line = (String)this.samples.read();
        while (line != null && !line.isEmpty()) {
            String[] parts = line.split(" ");
            if (parts.length != 4) {
                logger.warn("Skipping corrupt line {}: {}", (Object)this.count, (Object)line);
            } else {
                toks.add(parts[0]);
                posTags.add(parts[1]);
                chunkTags.add(parts[2]);
                predictedChunkTags.add(parts[3]);
            }
            ++this.count;
            line = (String)this.samples.read();
        }
        if (!toks.isEmpty()) {
            if (this.mIsPredicted) {
                return new ChunkSample(toks.toArray(new String[0]), posTags.toArray(new String[0]), predictedChunkTags.toArray(new String[0]));
            }
            return new ChunkSample(toks.toArray(new String[0]), posTags.toArray(new String[0]), chunkTags.toArray(new String[0]));
        }
        return null;
    }
}

